//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: ttoolbar.h,v 1.2 2001/11/20 15:19:35 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#include "desk.h"

class QToolButton;
class MainWindow;
class QButtonGroup;

//---------------------------------------------------------
//   TransportToolbar
//---------------------------------------------------------

class TransportToolbar : public ToolBar {
      Q_OBJECT
      QToolButton* playButton;
      QToolButton* recordButton;
      QToolButton* punchinButton;
      QToolButton* punchoutButton;
      QToolButton* stopButton;
      QToolButton* loopButton;
      QToolButton* rewindButton;
      QToolButton* forwardButton;
      QToolButton* startButton;
      QButtonGroup* playBg;

   private slots:
      void syncChanged(bool flag);

   public slots:
      void setPlay(bool);
      void setLoop(bool f);
      void setRecord(bool f);
      void setPunchin(bool f);
      void setPunchout(bool f);

   signals:
      void playChanged(bool);
      void loopChanged(bool);
      void recordChanged(bool);
      void punchinChanged(bool);
      void punchoutChanged(bool);

   public:
      TransportToolbar(MainWindow*, const char* name = 0);
      ~TransportToolbar();
      };

