//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: genset.cpp,v 1.2 2002/02/27 15:53:45 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include <stdio.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include "genset.h"
#include "song.h"
#include "globals.h"
#include "midithread.h"

static int rtcResolutions[] = {
      1024, 2048, 4096, 8192
      };
static int divisions[] = {
      48, 96, 192, 384, 768, 1536, 3072, 6144, 12288
      };

//---------------------------------------------------------
//   GlobalSettingsConfig
//---------------------------------------------------------

GlobalSettingsConfig::GlobalSettingsConfig(QWidget* parent=0, const char* name = 0)
   : GlobalSettingsDialogBase(parent, name)
      {
      for (unsigned i = 0; i < sizeof(rtcResolutions)/sizeof(*rtcResolutions); ++i) {
            if (rtcResolutions[i] == rtcTicks) {
                  rtcResolutionSelect->setCurrentItem(i);
                  break;
                  }
            }
      for (unsigned i = 0; i < sizeof(divisions)/sizeof(*divisions); ++i) {
            if (divisions[i] == division) {
                  midiDivisionSelect->setCurrentItem(i);
                  break;
                  }
            }
      guiRefreshSelect->setValue(guiRefresh);
      minSliderSelect->setValue(minSlider);
      minMeterSelect->setValue(minMeter);

      connect(applyButton, SIGNAL(clicked()), SLOT(apply()));
      connect(okButton, SIGNAL(clicked()), SLOT(ok()));
      connect(cancelButton, SIGNAL(clicked()), SLOT(cancel()));
      }

//---------------------------------------------------------
//   apply
//---------------------------------------------------------

void GlobalSettingsConfig::apply()
      {
      applySettings();
      }

//---------------------------------------------------------
//   ok
//---------------------------------------------------------

void GlobalSettingsConfig::ok()
      {
      applySettings();
      close();
      }

//---------------------------------------------------------
//   cancel
//---------------------------------------------------------

void GlobalSettingsConfig::cancel()
      {
      close();
      }

//---------------------------------------------------------
//   applySettings
//---------------------------------------------------------

void GlobalSettingsConfig::applySettings()
      {
      int rtcticks = rtcResolutionSelect->currentItem();
      int div      = midiDivisionSelect->currentItem();
      guiRefresh   = guiRefreshSelect->value();
      minSlider    = minSliderSelect->value();
      minMeter     = minMeterSelect->value();

      rtcTicks     = rtcResolutions[rtcticks];
      div          = divisions[div];

      printf("apply rtc:%d  div:%d\n", rtcticks, div);

      midiThread->setHeartBeat();        // set guiRefresh
      MidiMsg msg;
      msg.id = SEQM_SET_RTC_TICKS;
      midiThread->sendMessage(&msg, false);       // rtcTicks
      }

