//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: progname.cpp,v 1.1 2002/01/30 14:10:07 muse Exp $
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include "progname.h"

#define GMPROGRAMS      128
#define XGPROGRAMS      455
#define XGDRUMS         61
#define GSPROGRAMS      448
#define GSDRUMS         10

const char* gmdrumname = "GM Drums";

const char* gmGroups[PROG_GROUPS] = {
      "Piano",    "Chromatic Perc", "Organ",      "Guitar",
      "Bass",     "Strings/Orch",   "Ensemble",   "Brass",
      "Reed",     "Pipe",           "Synth Lead", "Synth Pad",
      "Synth FX", "Ethnic",         "Percussive", "Special FX",
      "Drums"
      };

static const MidiPatch patchGroup0[] = {
      { 7, 0, 0,  0, "Grand Piano" },
      { 4, 0, 1,  0, "GrndPnoK" },
      { 4, 0, 18, 0, "MelloGrP" },
      { 4, 0, 40, 0, "PianoStr" },
      { 4, 0, 41, 0, "Dream" },
      { 7, 0, 0,  1, "Bright Piano" },
      { 4, 0, 1,  1, "BritPnoK" },
      { 7, 0, 0,  2, "E.Grand"},
      { 4, 0, 1,  2, "ElGrPnoK" },
      { 4, 0, 32, 2, "Det.CP80" },
      { 4, 0, 40, 2, "ElGrPno1" },
      { 4, 0, 41, 2, "ElGrPno2" },
      { 7, 0, 0,  3, "Honky-tonk"},
      { 4, 0, 1,  3, "HonkyTonkK" },
      { 7, 0, 0,  4, "E.Piano 1"},
      { 4, 0, 1,  4, "El.Pno1K" },
      { 4, 0, 18, 4, "MelloEP1" },
      { 4, 0, 32, 4, "Chor.EP1" },
      { 4, 0, 40, 4, "HardEl.P" },
      { 4, 0, 45, 4, "VXElP1" },
      { 4, 0, 64, 4, "60sEl.P" },
      { 7, 0, 0,  5, "E.Piano 2"},
      { 4, 0, 1,  5, "El.Pno2K" },
      { 4, 0, 32, 5, "Chor.EP2" },
      { 4, 0, 33, 5, "DX.Hard" },
      { 4, 0, 34, 5, "DXLegend" },
      { 4, 0, 40, 5, "DXPhase" },
      { 4, 0, 41, 5, "DX+Analg" },
      { 4, 0, 42, 5, "DXKotoEP" },
      { 4, 0, 45, 5, "VXEl.P2" },
      { 7, 0, 0,  6, "Harpsichord"},
      { 4, 0, 1,  6, "Harpsi.K" },
      { 4, 0, 25, 6, "Harpsi.2" },
      { 4, 0, 35, 6, "Harpsi.3" },
      { 7, 0, 0,  7, "Clav."},
      { 4, 0, 1,  7, "Clavi.K" },
      { 4, 0, 27, 7, "ClaviWah" },
      { 4, 0, 64, 7, "PulseClv" },
      { 4, 0, 65, 7, "PierceCl" },
      { -1, -1, -1, -1, 0},
      };

static const MidiPatch patchGroup1[] = {
      { 7, 0,  0,  8, "Celesta",        },
      { 7, 0,  0,  9, "Glockenspiel",   },
      { 7, 0,  0, 10, "Music Box",      },
      { 4, 0, 64, 10, "Orgel" },
      { 7, 0,  0, 11, "Vibraphone",     },
      { 4, 0,  1, 11, "VibesK" },
      { 4, 0, 45, 11, "HardVibe" },
      { 7, 0,  0, 12, "Marimba",        },
      { 4, 0,  1, 12, "MarimbaK" },
      { 4, 0, 64, 12, "SineMrmb" },
      { 4, 0, 96, 12, "Balafon" },
      { 4, 0, 97, 12, "Balafon2" },
      { 4, 0, 98, 12, "LogDrum" },
      { 7, 0,  0, 13, "Xylophone",      },
      { 7, 0,  0, 14, "Tubular Bells",  },
      { 4, 0, 96, 14, "ChrchBel" },
      { 4, 0, 97, 14, "Carillon" },
      { 7, 0,  0, 15, "Dulcimer"        },
      { 4, 0, 35, 15, "Dulcimr2" },
      { 4, 0, 96, 15, "Cimbalom" },
      { 4, 0, 97, 15, "Santur" },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup2[] = {
      { 7, 0,  0, 16, "Drawbar Organ",  },
      { 4, 0, 32, 16, "DelDrwOr" },
      { 4, 0, 33, 16, "60sDrOr1" },
      { 4, 0, 34, 16, "60sDrOr2" },
      { 4, 0, 35, 16, "70sDrOr1" },
      { 4, 0, 36, 16, "DrawOrg2" },
      { 4, 0, 37, 16, "60sDrOr3" },
      { 4, 0, 38, 16, "EvenBar" },
      { 4, 0, 40, 16, "16+2\"2/3" },
      { 4, 0, 64, 16, "OrganBa" },
      { 4, 0, 65, 16, "70sDrOr2" },
      { 4, 0, 66, 16, "CheezOrg" },
      { 4, 0, 67, 16, "DrawOrg3" },
      { 7, 0,  0, 17, "Perc. Organ",    },
      { 4, 0, 24, 17, "70sPcOr1" },
      { 4, 0, 32, 17, "DetPrcOr" },
      { 4, 0, 33, 17, "LiteOrg" },
      { 4, 0, 37, 17, "PercOrg2" },
      { 7, 0,  0, 18, "Rock Organ",     },
      { 4, 0, 64, 18, "RotaryOr" },
      { 4, 0, 65, 18, "SloRotar" },
      { 4, 0, 66, 18, "FstRotar" },
      { 7, 0,  0, 19, "Church Organ",   },
      { 4, 0, 32, 19, "ChurOrg3" },
      { 4, 0, 35, 19, "ChurOrg2" },
      { 4, 0, 40, 19, "NotreDam" },
      { 4, 0, 64, 19, "OrgFlute" },
      { 4, 0, 65, 19, "TrmOrgFl" },
      { 7, 0,  0, 20, "Reed Organ",     },
      { 4, 0, 40, 20, "PuffOrg" },
      { 7, 0,  0, 21, "Akkordion",      },
      { 4, 0, 32, 21, "Accordlt" },
      { 7, 0,  0, 22, "Harmonica",      },
      { 4, 0, 32, 22, "Harmo2" },
      { 7, 0,  0, 23, "Bandoneon"       },
      { 4, 0, 64, 23, "TngoAcd2" },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup3[] = {
      { 7, 0,  0, 24, "Nylon Gtr.",     },
      { 4, 0, 16, 24, "NylonGt2" },
      { 4, 0, 25, 24, "NylonGt3" },
      { 4, 0, 43, 24, "VelGtHrm" },
      { 4, 0, 96, 24, "Ukelele" },
      { 7, 0,  0, 25, "Steel Gtr.",     },
      { 4, 0, 16, 25, "SteelGt2" },
      { 4, 0, 35, 25, "12StrGtr" },
      { 4, 0, 40, 25, "Nylon-Stl" },
      { 4, 0, 41, 25, "Stl-Body" },
      { 4, 0, 96, 25, "Mandolin" },
      { 7, 0,  0, 26, "Jazz Guitar",    },
      { 4, 0, 18, 26, "MelloGtr" },
      { 4, 0, 32, 26, "JazzAmp" },
      { 4, 0, 96, 26, "PdlSteel" },
      { 7, 0,  0, 27, "Clean Guitar",   },
      { 4, 0, 32, 27, "ChorusGt" },
      { 4, 0, 64, 27, "CleanGt2" },
      { 7, 0,  0, 28, "Muted Guitar",   },
      { 4, 0, 40, 28, "FunkGtr1" },
      { 4, 0, 41, 28, "MuteStlG" },
      { 4, 0, 43, 28, "FunkGtr2" },
      { 4, 0, 45, 28, "JazzMan" },
      { 4, 0, 96, 28, "Mu.DstGt" },
      { 7, 0,  0, 29, "Overdrive Gtr",  },
      { 4, 0, 43, 29, "Gt.Pinch" },
      { 7, 0,  0, 30, "Distortion Gtr", },
      { 4, 0, 12, 30, "DstRthmG" },
      { 4, 0, 24, 30, "DistGtr2" },
      { 4, 0, 35, 30, "DistGtr3" },
      { 4, 0, 36, 30, "PowerGt2" },
      { 4, 0, 37, 30, "PowerGt1" },
      { 4, 0, 38, 30, "Dst.5ths" },
      { 4, 0, 40, 30, "FeedbkGt" },
      { 4, 0, 41, 30, "FeedbGt2" },
      { 4, 0, 43, 30, "RkRythm2" },
      { 4, 0, 45, 30, "RockRthm" },
      { 7, 0,  0, 31, "Gtr. Harmonics"  },
      { 4, 0, 65, 31, "GtFeedbk" },
      { 4, 0, 66, 31, "GtrHrmo2" },
      { 4, 0, 64, 31, "AcoHarmo" },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup4[] = {
      { 7, 0,  0, 32, "Acoustic Bass",  },
      { 4, 0, 40, 32, "JazzRthm" },
      { 4, 0, 45, 32, "VXUprght" },
      { 7, 0,  0, 33, "Fingered Bass",  },
      { 4, 0, 18, 33, "FingrDrk" },
      { 4, 0, 27, 33, "FlangeBa" },
      { 4, 0, 40, 33, "Ba-DstEG" },
      { 4, 0, 43, 33, "FngrSlap" },
      { 4, 0, 45, 33, "FngBass2" },
      { 4, 0, 64, 33, "JazzBass" },
      { 4, 0, 65, 33, "ModAlem" },
      { 7, 0,  0, 34, "Picked Bass",    },
      { 4, 0, 28, 34, "MutePkBa" },
      { 7, 0,  0, 35, "Fretless Bass",  },
      { 4, 0, 32, 35, "Fretles2" },
      { 4, 0, 33, 35, "Fretles3" },
      { 4, 0, 34, 35, "Fretles4" },
      { 4, 0, 96, 35, "SynFretl" },
      { 4, 0, 97, 35, "Smooth" },
      { 7, 0,  0, 36, "Slap Bass 1",    },
      { 4, 0, 27, 36, "ResoSlap" },
      { 4, 0, 32, 36, "PunchThm" },
      { 7, 0,  0, 37, "Slap Bass 2",    },
      { 4, 0, 43, 37, "VeloSlap" },
      { 7, 0,  0, 38, "Synth Bass 1",   },
      { 4, 0, 18, 38, "SynBa1Dk" },
      { 4, 0, 20, 38, "FastResB" },
      { 4, 0, 24, 38, "AcidBass" },
      { 4, 0, 35, 38, "ClvBass" },
      { 4, 0, 40, 38, "TeknoBa" },
      { 4, 0, 64, 38, "Oscar" },
      { 4, 0, 65, 38, "SqrBass" },
      { 4, 0, 66, 38, "RubberBa" },
      { 4, 0, 96, 38, "Hammer" },
      { 7, 0,  0, 39, "Synth Bass 2"    },
      { 4, 0,  6, 39, "MelloSB1" },
      { 4, 0, 12, 39, "SeqBass" },
      { 4, 0, 18, 39, "ClkSynBa" },
      { 4, 0, 19, 39, "SynBa2Dk" },
      { 4, 0, 32, 39, "SmthBa2" },
      { 4, 0, 40, 39, "ModulrBa" },
      { 4, 0, 41, 39, "DXBass" },
      { 4, 0, 64, 39, "XWireBa" },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup5[] = {
      { 7, 0,  0, 40, "Violin",         },
      { 4, 0,  8, 40, "SlowVln" },
      { 7, 0,  0, 41, "Viola",          },
      { 7, 0,  0, 42, "Cello",          },
      { 7, 0,  0, 43, "Contrabass",     },
      { 7, 0,  0, 44, "Tremolo Str.",   },
      { 4, 0,  8, 44, "SlowTrSt" },
      { 4, 0, 40, 44, "SuspStr" },
      { 7, 0,  0, 45, "Pizzicato Str.", },
      { 7, 0,  0, 46, "Harp",           },
      { 4, 0, 40, 46, "YangChin" },
      { 7, 0,  0, 47, "Timpani",        },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup6[] = {
      { 7, 0,  0, 48, "Strings 1",      },
      { 4, 0,  3, 48, "S.Strngs" },
      { 4, 0,  8, 48, "SlowStr" },
      { 4, 0, 24, 48, "ArcoStr" },
      { 4, 0, 35, 48, "60sStrng" },
      { 4, 0, 40, 48, "Orchestr" },
      { 4, 0, 41, 48, "Orchstr2" },
      { 4, 0, 42, 48, "TremOrch" },
      { 4, 0, 45, 48, "VeloStr" },
      { 7, 0,  0, 49, "Strings 2",      },
      { 4, 0,  3, 49, "S.SlwStr" },
      { 4, 0,  8, 49, "LegatoSt" },
      { 4, 0, 40, 49, "WarmStr" },
      { 4, 0, 41, 49, "Kingdom" },
      { 4, 0, 64, 49, "70sStr" },
      { 4, 0, 65, 49, "StrEns3" },
      { 7, 0,  0, 50, "Syn. Strings 1", },
      { 4, 0, 27, 50, "ResoStr" },
      { 4, 0, 64, 50, "SynStr4" },
      { 4, 0, 65, 50, "SSStr" },
      { 4, 0, 35, 50, "SynStr3" },
      { 7, 0,  0, 51, "Syn. Strings 2", },
      { 7, 0,  0, 52, "Choir Aahs",     },
      { 4, 0,  3, 52, "S.Choir" },
      { 4, 0, 16, 52, "Ch.Aahs2" },
      { 4, 0, 32, 52, "MelChoir" },
      { 4, 0, 40, 52, "ChoirStr" },
      { 4, 0, 64, 52, "StrngAah" },
      { 4, 0, 65, 52, "MaleAah" },
      { 7, 0,  0, 53, "Voice Oohs",     },
      { 4, 0, 64, 53, "VoiceDoo" },
      { 4, 0, 96, 53, "VoiceHmn" },
      { 7, 0,  0, 54, "Synth Voice",    },
      { 4, 0, 40, 54, "SynVox2" },
      { 4, 0, 41, 54, "Choral" },
      { 4, 0, 64, 54, "AnaVoice" },
      { 7, 0,  0, 55, "Orchestra Hit"   },
      { 4, 0, 35, 55, "OrchHit2" },
      { 4, 0, 64, 55, "Impact" },
      { 4, 0, 66, 55, "DoublHit" },
      { 4, 0, 67, 55, "BrStab80" },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup7[] = {
      { 7, 0,  0, 56, "Trumpet",        },
      { 4, 0, 16, 56, "Trumpet2" },
      { 4, 0, 17, 56, "BriteTrp" },
      { 4, 0, 32, 56, "WarmTrp" },
      { 4, 0, 96, 56, "FluglHrn" },
      { 7, 0,  0, 57, "Trombone",       },
      { 4, 0, 18, 57, "Trmbone2" },
      { 7, 0,  0, 58, "Tuba",           },
      { 4, 0, 16, 58, "Tuba2" },
      { 7, 0,  0, 59, "Muted Trumpet",  },
      { 4, 2, 64, 59, "MuteTrp2" },
      { 7, 0,  0, 60, "French Horn",    },
      { 4, 0,  6, 60, "FrHrSolo" },
      { 4, 0, 32, 60, "FrHorn2" },
      { 4, 0, 37, 60, "HornOrch" },
      { 7, 0,  0, 61, "Brass Section",  },
      { 4, 0, 35, 61, "Tp-TbSec" },
      { 4, 0, 40, 61, "BrssSec2" },
      { 4, 0, 41, 61, "HiBrass" },
      { 4, 0, 42, 61, "MelloBrs" },
      { 4, 0, 14, 61, "SfrzndBr" },
      { 4, 0, 39, 61, "BrssFall" },
      { 7, 0,  0, 62, "Synth Brass 1",  },
      { 4, 0, 12, 62, "QuackBr" },
      { 4, 0, 20, 62, "RezSynBr" },
      { 4, 0, 24, 62, "PolyBrss" },
      { 4, 0, 27, 62, "SynBras3" },
      { 4, 0, 32, 62, "JumpBrss" },
      { 4, 0, 45, 62, "AnaVelBr" },
      { 4, 0, 64, 62, "AnaBrss1" },
      { 7, 0,  0, 63, "Synth Brass 2"   },
      { 4, 0, 18, 63, "SoftBrs" },
      { 4, 0, 40, 63, "SynBras4" },
      { 4, 0, 41, 63, "ChoBrss" },
      { 4, 0, 45, 63, "VelBras2" },
      { 4, 0, 64, 63, "AnaBras2" },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup8[] = {
      { 7, 0,  0, 64, "Soprano Sax",    },
      { 7, 0,  0, 65, "Alto Sax",       },
      { 4, 0, 40, 65, "SaxSect" },
      { 4, 0, 43, 65, "HyprAlto" },
      { 7, 0,  0, 66, "Tenor Sax",      },
      { 4, 0, 40, 66, "BrthTnSx" },
      { 4, 0, 41, 66, "SoftTenr" },
      { 4, 0, 64, 66, "TnrSax2" },
      { 7, 0,  0, 67, "Baritone Sax",   },
      { 7, 0,  0, 68, "Oboe",           },
      { 7, 0,  0, 69, "English Horn",   },
      { 7, 0,  0, 70, "Bassoon",        },
      { 7, 0,  0, 71, "Clarinet"        },
      { 4, 0, 96, 71, "BassClar" },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup9[] = {
      { 7, 0,  0, 72, "Piccolo",        },
      { 7, 0,  0, 73, "Flute",          },
      { 7, 0,  0, 74, "Recorder",       },
      { 7, 0,  0, 75, "Pan Flute",      },
      { 4, 0, 64, 75, "PanFlut2" },
      { 4, 0, 96, 75, "Kawala" },
      { 7, 0,  0, 76, "Blown Bottle",   },
      { 7, 0,  0, 77, "Shakuhachi",     },
      { 7, 0,  0, 78, "Whistle",        },
      { 7, 0,  0, 79, "Ocarina"         },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup10[] = {
      { 7, 0,  0, 80, "Square Wave",    },
      { 4, 0,  6, 80, "Square2" },
      { 4, 0,  8, 80, "LMSquare" },
      { 4, 0, 18, 80, "Hollow" },
      { 4, 0, 19, 80, "Shmoog" },
      { 4, 0, 64, 80, "Mellow" },
      { 4, 0, 65, 80, "SoloSine" },
      { 4, 0, 66, 80, "SineLead" },
      { 7, 0,  0, 81, "Saw Wave",       },
      { 4, 0,  6, 81, "Saw2" },
      { 4, 0,  8, 81, "ThickSaw" },
      { 4, 0, 18, 81, "DynaSaw" },
      { 4, 0, 19, 81, "DigiSaw" },
      { 4, 0, 20, 81, "BigLead" },
      { 4, 0, 24, 81, "HeavySyn" },
      { 4, 0, 25, 81, "WaspySyn" },
      { 4, 0, 40, 81, "PulseSaw" },
      { 4, 0, 41, 81, "Dr.Lead" },
      { 4, 0, 45, 81, "VeloLead" },
      { 4, 0, 96, 81, "SeqAna" },
      { 7, 0,  0, 82, "Calliope",       },
      { 4, 0, 65, 82, "PurePad" },
      { 4, 0, 64, 82, "VentSyn" },
      { 7, 0,  0, 83, "Chiffer Lead",   },
      { 4, 0, 64, 83, "Rubby" },
      { 7, 0,  0, 84, "Charang",        },
      { 4, 0, 64, 84, "DistLead" },
      { 4, 0, 65, 84, "WireLead" },
      { 7, 0,  0, 85, "Solo Vox",       },
      { 4, 0, 24, 85, "SynthAah" },
      { 4, 0, 64, 85, "VoxLead" },
      { 7, 0,  0, 86, "Fifth Saw",      },
      { 4, 0, 35, 86, "BigFive" },
      { 7, 0,  0, 87, "Bass Lead"       },
      { 4, 0, 16, 87, "Big-Low" },
      { 4, 0, 64, 87, "Fat-Prky" },
      { 4, 0, 65, 87, "SoftWurl" },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup11[] = {
      { 7, 0,  0, 88, "New Age Pad",    },
      { 4, 0, 64, 88, "Fantasy2" },
      { 7, 0,  0, 89, "Warm Pad",       },
      { 4, 0, 16, 89, "ThickPad" },
      { 4, 0, 17, 89, "SoftPad" },
      { 4, 0, 18, 89, "SinePad" },
      { 4, 0, 64, 89, "HornPad" },
      { 4, 0, 65, 89, "RotarStr" },
      { 7, 0,  0, 90, "Polysynth Pad",  },
      { 4, 0, 64, 90, "PolyPd80" },
      { 4, 0, 65, 90, "ClickPad" },
      { 4, 0, 66, 90, "AnaPad" },
      { 4, 0, 67, 90, "SquarPad" },
      { 7, 0,  0, 91, "Choir Pad",      },
      { 4, 0, 64, 91, "Heaven2" },
      { 4, 0, 66, 91, "Itopia" },
      { 4, 0, 67, 91, "CCPad" },
      { 4, 0, 65, 91, "LitePad" },
      { 7, 0,  0, 92, "Bowed Pad",      },
      { 4, 0, 64, 92, "Glacier" },
      { 4, 0, 65, 92, "GlassPad" },
      { 7, 0,  0, 93, "Metallic Pad",   },
      { 4, 0, 64, 93, "TinePad" },
      { 4, 0, 65, 93, "PanPad" },
      { 7, 0,  0, 94, "Halo Pad",       },
      { 7, 0,  0, 95, "Sweep Pad"       },
      { 4, 0, 20, 95, "Shwimmer" },
      { 4, 0, 27, 95, "Converge" },
      { 4, 0, 64, 95, "PolarPad" },
      { 4, 0, 66, 95, "Celstial" },
      { 4, 0, 65, 95, "Sweepy" },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup12[] = {
      { 7, 0,  0, 96, "Rain",           },
      { 4, 0, 45, 96, "ClaviPad" },
      { 4, 0, 64, 96, "HrmoRain" },
      { 4, 0, 65, 96, "AfrcnWnd" },
      { 4, 0, 66, 96, "Caribean" },
      { 7, 0,  0, 97, "Soundtrack",     },
      { 4, 0, 27, 97, "Prologue" },
      { 4, 0, 64, 97, "Ancestrl" },
      { 4, 0, 65, 97, "Rave" },
      { 7, 0,  0, 98, "Crystal",        },
      { 4, 0, 12, 98, "SynDrCmp" },
      { 4, 0, 14, 98, "Popcorn" },
      { 4, 0, 18, 98, "TinyBell" },
      { 4, 0, 35, 98, "RndGlock" },
      { 4, 0, 40, 98, "GlockChi" },
      { 4, 0, 41, 98, "ClearBel" },
      { 4, 0, 42, 98, "ChorBell" },
      { 4, 0, 64, 98, "SynMalet" },
      { 4, 0, 65, 98, "SftCryst" },
      { 4, 0, 66, 98, "LoudGlok" },
      { 4, 0, 67, 98, "XmasBell" },
      { 4, 0, 68, 98, "VibeBell" },
      { 4, 0, 69, 98, "DigiBell" },
      { 4, 0, 70, 98, "AirBells" },
      { 4, 0, 71, 98, "BellHarp" },
      { 4, 0, 72, 98, "Gamelmba" },
      { 7, 0,  0, 99, "Athmosphere",    },
      { 4, 0, 18, 99, "WarmAtms" },
      { 4, 0, 19, 99, "HollwRls" },
      { 4, 0, 40, 99, "NylonEP" },
      { 4, 0, 64, 99, "NylnHarp" },
      { 4, 0, 65, 99, "HarpVox" },
      { 7, 0,  0, 100, "Brightness",    },
      { 7, 0,  0, 101, "Goblins",       },
      { 4, 0, 69, 101, "MilkyWay" },
      { 4, 0, 72, 101, "Puffy" },
      { 7, 0,  0, 102, "Echoes",        },
      { 7, 0,  0, 103, "Sci-Fi"         },
      { 4, 0, 65, 103, "Odyssey" },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup13[] = {
      { 7, 0,  0, 104, "Sitar",         },
      { 4, 0, 32, 104, "DetSitar" },
      { 4, 0, 35, 104, "Sitar2" },
      { 4, 0, 96, 104, "Tambra" },
      { 4, 0, 97, 104, "Tamboura" },
      { 7, 0,  0, 105, "Banjo",         },
      { 4, 0, 28, 105, "MuteBnjo" },
      { 4, 0, 96, 105, "Rabab" },
      { 4, 0, 97, 105, "Gopichnt" },
      { 4, 0, 98, 105, "Oud" },
      { 7, 0,  0, 106, "Shamisen",      },
      { 4, 0, 96, 106, "Tsugaru" },
      { 7, 0,  0, 107, "Koto",          },
      { 4, 0, 96, 107, "T.Koto" },
      { 4, 0, 97, 107, "Kanoon" },
      { 7, 0,  0, 108, "Kalimba",       },
      { 4, 0, 64, 108, "BigKalim" },
      { 7, 0,  0, 109, "Bagpipe",       },
      { 7, 0,  0, 110, "Fiddle",        },
      { 7, 0,  0, 111, "Shanai"         },
      { 4, 0, 64, 111, "Shanai2" },
      { 4, 0, 96, 111, "Pungi" },
      { 4, 0, 97, 111, "Hichriki" },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup14[] = {
      { 7, 0,   0, 112, "Tinkle Bell",   },
      { 4, 0,  96, 112, "Bonang" },
      { 4, 0,  97, 112, "Gender" },
      { 4, 0,  98, 112, "Gamelan" },
      { 4, 0,  99, 112, "S.Gamlan" },
      { 4, 0, 100, 112, "RamaCym" },
      { 4, 0, 101, 112, "AsianBel" },
      { 7, 0,   0, 113, "Agogo",         },
      { 4, 0,  96, 113, "Atrigane" },
      { 7, 0,   0, 114, "Steel Drums",   },
      { 4, 0,  97, 114, "GlasPerc" },
      { 4, 0,  98, 114, "ThaiBell" },
      { 4, 0,  96, 114, "Tablas" },
      { 7, 0,   0, 115, "Woodblock",     },
      { 4, 0,  96, 115, "Castanet" },
      { 7, 0,   0, 116, "Taiko Drum",    },
      { 4, 0,  96, 116, "Gr.Cassa" },
      { 7, 0,   0, 117, "Melodic Drum",  },
      { 4, 0,  64, 117, "MelTom2" },
      { 4, 0,  65, 117, "RealTom" },
      { 4, 0,  66, 117, "RockTom" },
      { 7, 0,   0, 118, "Synth Drum",    },
      { 4, 0,  64, 118, "AnaTom" },
      { 4, 0,  65, 118, "ElecPerc" },
      { 7, 0,   0, 119, "Rev. Cymbal"    },
      { 4, 0,  64, 119, "RevCym2" },
      { 4, 0,  96, 119, "RevSnar1" },
      { 4, 0,  97, 119, "RevSnar2" },
      { 4, 0,  98, 119, "RevKick1" },
      { 4, 0,  99, 119, "RevConBD" },
      { 4, 0, 100, 119,  "RevTom1" },
      { 4, 0, 101, 119,  "RevTom2" },
      { -1, -1, -1, -1, 0},
      };
static const MidiPatch patchGroup15[] = {
      { 7, 0, 0, 120, "Gtr Fret Noise",},
      { 7, 0, 0, 121, "Breath Noise",  },
      { 7, 0, 0, 122, "Seashore",      },
      { 7, 0, 0, 123, "Bird Tweed",    },
      { 7, 0, 0, 124, "Telephone",     },
      { 7, 0, 0, 125, "Helicopter",    },
      { 7, 0, 0, 126, "Applaus",       },
      { 7, 0, 0, 127, "Gunshot"        },
      { -1, -1, -1, -1, 0},
      };

static const MidiPatch patchGroup16[] = {
      { 6, 127, 0,   0, "Standard" },
      { 4, 127, 0,   1, "Standrd2" },
      { 6, 127, 0,   8, "Room" },
      { 4, 127, 0,  16, "Rock" },
      { 6, 127, 0,  24, "Electro" },
      { 6, 127, 0,  25, "Analog" },
      { 6, 127, 0,  32, "Jazz" },
      { 6, 127, 0,  40, "Brush" },
      { 6, 127, 0,  48, "Classic" },

      { 2, 127, 0,  16, "Power" },
      { 2, 127, 0,  56, "SFX1" },
      { 2, 127, 0, 127, "GM" },

      { 4, 126, 0,   0, "SFX1" },
      { 4, 126, 0,   1, "SFX2" },

      { 4,  64, 0,   0, "CuttngNz" },
      { 4,  64, 0,   1, "CuttngNz2" },
      { 4,  64, 0,   3, "StrSlap" },
      { 4,  64, 0,  16, "Fl.KClik" },
      { 4,  64, 0,  32, "Rain" },
      { 4,  64, 0,  33, "Thunder" },
      { 4,  64, 0,  34, "Wind" },
      { 4,  64, 0,  35, "Stream" },
      { 4,  64, 0,  36, "Bubble" },
      { 4,  64, 0,  37, "Feed" },
      { 4,  64, 0,  48, "Dog" },
      { 4,  64, 0,  49, "Horse" },
      { 4,  64, 0,  50, "Bird2" },
      { 4,  64, 0,  54, "Ghost" },
      { 4,  64, 0,  55, "Maou" },
      { 4,  64, 0,  64, "Tel.Dial" },
      { 4,  64, 0,  65, "DoorSqek" },
      { 4,  64, 0,  66, "DoorSlam" },
      { 4,  64, 0,  67, "Scratch" },
      { 4,  64, 0,  68, "Scratch2" },
      { 4,  64, 0,  69, "WindChm" },
      { 4,  64, 0,  70, "Telphon2" },
      { 4,  64, 0,  80, "CarEngin" },
      { 4,  64, 0,  81, "CarStop" },
      { 4,  64, 0,  82, "CarPass" },
      { 4,  64, 0,  83, "CarCrash" },
      { 4,  64, 0,  84, "Siren" },
      { 4,  64, 0,  85, "Train" },
      { 4,  64, 0,  86, "Jetplane" },
      { 4,  64, 0,  87, "Starship" },
      { 4,  64, 0,  88, "Burst" },
      { 4,  64, 0,  89, "Coaster" },
      { 4,  64, 0,  90, "SbMarine" },
      { 4,  64, 0,  96, "Laughing" },
      { 4,  64, 0,  97, "Scream" },
      { 4,  64, 0,  98, "Punch" },
      { 4,  64, 0,  99, "Heart" },
      { 4,  64, 0, 100, "FootStep" },
      { 4,  64, 0, 112, "MchinGun" },
      { 4,  64, 0, 113, "LaserGun" },
      { 4,  64, 0, 114, "Xplosion" },
      { 4,  64, 0, 115, "FireWork" },
      { 4,  64, 0,   2, "DstCutNz" },
      { 4,  64, 0,   4, "B.Slide" },
      { 4,  64, 0,   5, "P.Scrape" },
      { 4,  64, 0,  51, "Kitty" },
      { 4,  64, 0,  52, "Growl" },
      { 4,  64, 0,  53, "Haunted" },
      { 4,  64, 0, 101, "Applaus2" },
      { -1, -1, -1, -1, 0},
      };

const MidiPatch* patchGroups[PROG_GROUPS] = {
      patchGroup0, patchGroup1, patchGroup2, patchGroup3,
      patchGroup4, patchGroup5, patchGroup6, patchGroup7,
      patchGroup8, patchGroup9, patchGroup10, patchGroup11,
      patchGroup12, patchGroup13, patchGroup14, patchGroup15,
      patchGroup16
      };

//---------------------------------------------------------
//   patch
//---------------------------------------------------------

const char* getPatch(int channel, int hbank, int lbank, int prog, MType mode)
      {
      if (prog < 0)
            return "---";
      if (lbank < 0)
            lbank = 0;
      if (hbank < 0)
            hbank = 0;

      switch(mode) {
            case MT_GS:
                  if (channel == 9) {  // gm drums
                        for (const MidiPatch* p = patchGroup16; p->name; ++p) {
                              if ((p->typ & 2) && (prog == p->prog))
                                    return p->name;
                              }
                        break;
                        }
                  for (int i = 0; i < 16; ++i) {
                        for (const MidiPatch* p = patchGroups[i]; p->name; ++p) {
                              if ((p->typ & 2) && (p->hbank == hbank)
                                 && (prog == p->prog))
                                    return p->name;
                              }
                        }
                  break;
            case MT_XG:
                  if (channel == 9) {
                        for (const MidiPatch* p = patchGroup16; p->name; ++p) {
                              if ((p->typ & 4) && (p->lbank == lbank)
                                 && (p->hbank == hbank) && (prog == p->prog))
                                    return p->name;
                              }

                        break;
                        }
                  for (int i = 0; i < 16; ++i) {
                        for (const MidiPatch* p = patchGroups[i]; p->name; ++p) {
                              if ((p->typ & 4) && (p->lbank == lbank)
                                 && (prog == p->prog))
                                    return p->name;
                              }
                        }
                  break;
            default:
                  if (channel == 9)
                        return gmdrumname;
                  for (int i = 0; i < 16; ++i) {
                        for (const MidiPatch* p = patchGroups[i]; p->name; ++p) {
                              if ((p->typ & 1) && (prog == p->prog))
                                    return p->name;
                              }
                        }
                  break;
            }
      return "---";
      }

