#ifndef _OPIE_VTYPE_H_
#define _OPIE_VTYPE_H_

/* 
   MultiSync Opie Plugin - Synchronize Opie/Zaurus Devices
   Copyright (C) 2003 Tom Foottit <tom@foottit.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation;

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
   IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) AND AUTHOR(S) BE LIABLE FOR ANY
   CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES 
   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN 
   ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF 
   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

   ALL LIABILITY, INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PATENTS, 
   COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS, RELATING TO USE OF THIS 
   SOFTWARE IS DISCLAIMED.
*/

/*
 *  $Id: opie_vtype.h,v 1.1 2003/07/11 21:21:04 irix Exp $
 */

#include "opie_comms.h"

/* convert calendar vCal - caller must free */
char* cal_data_to_vcal(cal_data* calendar, GList* categories);


/* convert contact vCard - caller must free */
char* contact_data_to_vcard(contact_data* contact, GList* categories);


/* convert todo vTodo - caller must free */
char* todo_data_to_vtodo(todo_data* todo, GList* categories);


/* convert vCal to calendar - caller must free */
cal_data* vcal_to_cal_data(char* vcal, GList** categories);


/* convert vCard to contact - caller must free */
contact_data* vcard_to_contact_data(char* vcard, GList** categories);


/* convert vTodo to todo - caller must free */
todo_data* vtodo_to_todo_data(char* vtodo, GList** categories);

#endif
