/*
 * $Id: ChatStringToString.java 10789 2008-02-12 20:04:43Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.example.hello;

import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;

/**
 * <code>NameStringToChatString</code> is a dummy transform used in the hello world
 * application to transform the ChatString object into a string
 * 
 * @author <a href="mailto:ross.mason@symphonysoft.com">Ross Mason</a>
 * @version $Revision: 10789 $
 */
public class ChatStringToString extends AbstractTransformer
{
    /**
     * Serial version
     */
    private static final long serialVersionUID = 8633726064696217003L;

    public ChatStringToString()
    {
        super();
        this.registerSourceType(ChatString.class);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.mule.transformers.AbstractTransformer#doTransform(java.lang.Object)
     */
    public Object doTransform(Object src, String encoding) throws TransformerException
    {
        ChatString string = (ChatString)src;
        return string.toString();
    }
}
