/*
 *   Copyright (C) 1991-2000 by Jonathan Naylor HB9DRD/G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include <gtk/gtk.h>

#include "global.h"

GdkColor Text_Bg_Colour = {0, 48830, 48830, 48830};	/* Grey   */
GdkColor Text_Fg_Colour = {0, 0,     0,     0};		/* Black  */

static int          Colour_Element;

static GdkColormap *Colour_Map;

static void     ColourSelCb(GtkWidget *, GtkWidget *);
static void     ColourChangedCb(GtkWidget *, GtkColorSelection *);
static void     ColourCancelCb(GtkWidget *, GtkWidget *);

void ColourCb(GtkWidget *w, gpointer data)
{
	GtkWidget         *colourseldlg;
	GtkColorSelection *coloursel;
	char              *name = NULL;
	gdouble           colour[3];

	Colour_Element = (int)data;

	switch (Colour_Element) {
		case COLOUR_BACKGROUND:
			name = "Select Map Background Colour";
			break;
		case COLOUR_CITIES:
			name = "Select Cities Colour";
			break;
		case COLOUR_FOOTPRINT:
			name = "Select Satellite Footprint Colour";
			break;
		case COLOUR_LAND:
			name = "Select Map Land Colour";
			break;
		case COLOUR_SATELLITE:
			name = "Select Satellite Position Colour";
			break;
		case COLOUR_USER:
			name = "Select User Position Colour";
			break;
		default:
			g_error("mtrack: unknown colour item %d\n", Colour_Element);
			break;
	}

	colourseldlg = gtk_color_selection_dialog_new(name);
	coloursel    = GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(colourseldlg)->colorsel);

	colour[0] = (double)User_Data.Colours[Colour_Element].red   / 65535.0;
	colour[1] = (double)User_Data.Colours[Colour_Element].green / 65535.0;
	colour[2] = (double)User_Data.Colours[Colour_Element].blue  / 65535.0;

	gtk_color_selection_set_color(GTK_COLOR_SELECTION(coloursel), colour);

	gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colourseldlg)->cancel_button), "clicked",       (GtkSignalFunc)ColourCancelCb,  colourseldlg);
	gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colourseldlg)->ok_button),     "clicked",       (GtkSignalFunc)ColourSelCb,     colourseldlg);
	gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colourseldlg)->colorsel),      "color_changed", (GtkSignalFunc)ColourChangedCb, coloursel);

	gtk_widget_show(colourseldlg);
}

static void ColourSelCb(GtkWidget *widget, GtkWidget *colourseldlg)
{
	gdouble            colour[3];
	GdkColor           gdkcolour;
	GtkColorSelection *coloursel;

	coloursel = GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(colourseldlg)->colorsel);

	gtk_color_selection_get_color(coloursel, colour);

	gdkcolour.pixel = 0;
	gdkcolour.red   = (guint)(colour[0] * 65535.0 + 0.5);
	gdkcolour.green = (guint)(colour[1] * 65535.0 + 0.5);
	gdkcolour.blue  = (guint)(colour[2] * 65535.0 + 0.5);

	gdk_color_alloc(Colour_Map, &gdkcolour);

	switch (Colour_Element) {
		case COLOUR_BACKGROUND:
			User_Data.Colours[COLOUR_BACKGROUND] = gdkcolour;
			gdk_gc_set_foreground(BackgroundGC, &gdkcolour);
			Redraw_Satellites();
			break;
		case COLOUR_CITIES:
			User_Data.Colours[COLOUR_CITIES] = gdkcolour;
			gdk_gc_set_foreground(CitiesGC, &gdkcolour);
			Redraw_Satellites();
			break;
		case COLOUR_FOOTPRINT:
			User_Data.Colours[COLOUR_FOOTPRINT] = gdkcolour;
			gdk_gc_set_foreground(FootprintGC, &gdkcolour);
			Redraw_Satellites();
			break;
		case COLOUR_LAND:
			User_Data.Colours[COLOUR_LAND] = gdkcolour;
			gdk_gc_set_foreground(LandGC, &gdkcolour);
			Redraw_Satellites();
			break;
		case COLOUR_SATELLITE:
			User_Data.Colours[COLOUR_SATELLITE] = gdkcolour;
			gdk_gc_set_foreground(SatelliteGC, &gdkcolour);
			Redraw_Satellites();
			break;
		case COLOUR_USER:
			User_Data.Colours[COLOUR_USER] = gdkcolour;
			gdk_gc_set_foreground(UserGC, &gdkcolour);
			Redraw_Satellites();
			break;
		default:
			g_error("mtrack: unknown colour item %d\n", Colour_Element);
			break;
	}

	gtk_widget_destroy(colourseldlg);
}

static void ColourCancelCb(GtkWidget *widget, GtkWidget *colourseldlg)
{
	switch (Colour_Element) {
		case COLOUR_BACKGROUND:
			gdk_gc_set_foreground(BackgroundGC, &User_Data.Colours[COLOUR_BACKGROUND]);
			Redraw_Satellites();
			break;
		case COLOUR_CITIES:
			gdk_gc_set_foreground(CitiesGC, &User_Data.Colours[COLOUR_CITIES]);
			Redraw_Satellites();
			break;
		case COLOUR_FOOTPRINT:
			gdk_gc_set_foreground(FootprintGC, &User_Data.Colours[COLOUR_FOOTPRINT]);
			Redraw_Satellites();
			break;
		case COLOUR_LAND:
			gdk_gc_set_foreground(LandGC, &User_Data.Colours[COLOUR_LAND]);
			Redraw_Satellites();
			break;
		case COLOUR_SATELLITE:
			gdk_gc_set_foreground(SatelliteGC, &User_Data.Colours[COLOUR_SATELLITE]);
			Redraw_Satellites();
			break;
		case COLOUR_USER:
			gdk_gc_set_foreground(UserGC, &User_Data.Colours[COLOUR_USER]);
			Redraw_Satellites();
			break;
		default:
			g_error("mtrack: unknown colour item %d\n", Colour_Element);
			break;
	}

	gtk_widget_destroy(colourseldlg);
}

static void ColourChangedCb(GtkWidget *widget, GtkColorSelection *coloursel)
{
	gdouble            colour[3];
	GdkColor           gdkcolour;

	gtk_color_selection_get_color(coloursel, colour);

	gdkcolour.pixel = 0;
	gdkcolour.red   = (guint)(colour[0] * 65535.0 + 0.5);
	gdkcolour.green = (guint)(colour[1] * 65535.0 + 0.5);
	gdkcolour.blue  = (guint)(colour[2] * 65535.0 + 0.5);

	gdk_color_alloc(Colour_Map, &gdkcolour);

	switch (Colour_Element) {
		case COLOUR_BACKGROUND:
			gdk_gc_set_foreground(BackgroundGC, &gdkcolour);
			Redraw_Satellites();
			break;
		case COLOUR_CITIES:
			gdk_gc_set_foreground(CitiesGC, &gdkcolour);
			Redraw_Satellites();
			break;
		case COLOUR_FOOTPRINT:
			gdk_gc_set_foreground(FootprintGC, &gdkcolour);
			Redraw_Satellites();
			break;
		case COLOUR_LAND:
			gdk_gc_set_foreground(LandGC, &gdkcolour);
			Redraw_Satellites();
			break;
		case COLOUR_SATELLITE:
			gdk_gc_set_foreground(SatelliteGC, &gdkcolour);
			Redraw_Satellites();
			break;
		case COLOUR_USER:
			gdk_gc_set_foreground(UserGC, &gdkcolour);
			Redraw_Satellites();
			break;
		default:
			g_error("mtrack: unknown colour item %d\n", Colour_Element);
			break;
	}
}

void Allocate_Colours(void)
{
	static int First_Time = TRUE;

	if (First_Time) {
		Colour_Map = gdk_colormap_get_system();

		gdk_color_alloc(Colour_Map, &User_Data.Colours[COLOUR_BACKGROUND]);
		gdk_color_alloc(Colour_Map, &User_Data.Colours[COLOUR_CITIES]);
		gdk_color_alloc(Colour_Map, &User_Data.Colours[COLOUR_FOOTPRINT]);
		gdk_color_alloc(Colour_Map, &User_Data.Colours[COLOUR_LAND]);
		gdk_color_alloc(Colour_Map, &User_Data.Colours[COLOUR_SATELLITE]);
		gdk_color_alloc(Colour_Map, &User_Data.Colours[COLOUR_USER]);
		gdk_color_alloc(Colour_Map, &Text_Fg_Colour);
		gdk_color_alloc(Colour_Map, &Text_Bg_Colour);

		First_Time = FALSE;
	}
}
