/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000 CodeFactory AB
 * Copyright (C) 2000 Richard Hult <rhult@codefactory.se>
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __TASK_MODEL_H__
#define __TASK_MODEL_H__

#include <glib.h>
#include <gtk/gtkobject.h>
#include <gtk/gtktypeutils.h>
#include "libmrproject/GNOME_MrProject.h"
#include "util/corba-utils.h"

#define TYPE_TASK_MODEL		(task_model_get_type ())
#define TASK_MODEL(obj)		(GTK_CHECK_CAST ((obj), TYPE_TASK_MODEL, TaskModel))
#define TASK_MODEL_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), TYPE_TASK_MODEL, TaskModelClass))
#define IS_TASK_MODEL(obj)	(GTK_CHECK_TYPE ((obj), TYPE_TASK_MODEL))
#define IS_TASK_MODEL_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((obj), TYPE_TASK_MODEL))

typedef struct _TaskModel TaskModel;
typedef struct _TaskModelClass TaskModelClass;
typedef struct _TaskModelPriv TaskModelPriv;

struct _TaskModel
{
	GtkObject	       parent;
	TaskChangeMask         change_mask;
	gint                   change_idle_id;
};

struct _TaskModelClass
{
	GtkObjectClass	 parent_class;

	/*
	 * Methods
	 */
	void (*add_predecessor)    (TaskModel                  *task,
				    const GM_Dependency        *dependency);
	void (*add_successor)      (TaskModel                  *task,
				    const GM_Dependency        *dependency);
	void (*remove_predecessor) (TaskModel                  *task,
				    GM_Id                       id);
	void (*remove_successor)   (TaskModel                  *task,
				    GM_Id                       id);
	GSList *(*get_predecessors)(TaskModel                  *task);
	GSList *(*get_successors)  (TaskModel                  *task);

	gboolean (*has_predecessor)(TaskModel                  *task,
				    GM_Id                       id,
				    GM_Id                      *dependency_id);
	gboolean (*has_successor)  (TaskModel                  *task,
				    GM_Id                       id,
				    GM_Id                      *dependency_id);
	gboolean (*has_ancestor)   (TaskModel                  *task,
				    TaskModel                  *ancestor);
	GM_Task *(*get_task)       (TaskModel                  *task);
	gint (*get_num_children)   (TaskModel                  *task);
};

#define task_model_get_node(t) (t->node)
#define task_model_is_leaf(t) (G_NODE_IS_LEAF (t->node))

GtkType	    task_model_get_type  (void);
void        task_model_changed   (TaskModel                  *task,
				  TaskChangeMask              mask);
GNOME_MrProject_Task *
task_model_get_task              (TaskModel                  *task);
GNOME_MrProject_DependencySeq *
task_model_get_predecessors_seq  (TaskModel                  *task);

GNOME_MrProject_DependencySeq *
task_model_get_successors_seq    (TaskModel                  *task);

GSList *
task_model_get_predecessors      (TaskModel                  *task);

GSList *
task_model_get_successors        (TaskModel                  *task);

void task_model_add_predecessor  (TaskModel                  *task,
				  const GNOME_MrProject_Dependency *dependency);

void task_model_add_successor    (TaskModel                  *task,
				  const GNOME_MrProject_Dependency *dependency);

void task_model_remove_predecessor(TaskModel                 *task,
				  GNOME_MrProject_Id          id);

void task_model_remove_successor (TaskModel                  *task,
				  GNOME_MrProject_Id          id);

gboolean
task_model_has_predecessor       (TaskModel                  *task,
				  GNOME_MrProject_Id          id,
				  GNOME_MrProject_Id         *dependency_id);

gboolean
task_model_has_successor         (TaskModel                  *task,
				  GNOME_MrProject_Id          id,
				  GNOME_MrProject_Id         *dependency_id);

gboolean task_model_has_ancestor (TaskModel *task, TaskModel *ancestor);
gint task_model_get_num_children (TaskModel *task);


#endif /* __TASK_MODEL_H__ */

