/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000 CodeFactory AB
 * Copyright (C) 2000 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef _SHELL_H_
#define _SHELL_H_

#include <bonobo/bonobo-xobject.h>
#include "libmrproject/GNOME_MrProject.h"
#include "util/corba-utils.h"

#define SHELL_TYPE        (shell_get_type ())
#define SHELL(o)          (GTK_CHECK_CAST ((o), SHELL_TYPE, Shell))
#define SHELL_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), SHELL_TYPE, ShellClass))
#define IS_SHELL(o)       (GTK_CHECK_TYPE ((o), SHELL_TYPE))
#define IS_SHELL_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), SHELL_TYPE))

typedef struct _Shell      Shell;
typedef struct _ShellClass ShellClass;
typedef struct _ShellPriv  ShellPriv;

#include "project-window.h"

struct _Shell {
	BonoboXObject parent;
	ShellPriv *priv;
};

struct _ShellClass {
	BonoboXObjectClass parent_class;
	POA_GNOME_MrProject_Shell__epv epv;
}; 


GtkType	    shell_get_type         (void);
Shell      *shell_new              (ProjectWindow     *window,
				    BonoboUIContainer *ui_container);
void        shell_activate_control (Shell *shell, const gchar *id);
void	    shell_open             (Shell *shell, const gchar *uri, CORBA_Environment *ev);
void	    shell_save             (Shell *shell, const gchar *uri, CORBA_Environment *ev);
GM_Project  shell_get_project      (Shell *shell);
void        shell_set_range        (Shell *shell, time_t first, time_t last);
void        shell_remove_from_project (Shell *shell);

#endif /* _SHELL_H_ */

