/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/time.h>
#include <unistd.h>
#include <locale.h>
#include <gal/util/e-util.h>
#include <gal/e-table/e-cell.h>
#include <gal/e-table/e-table-model.h>
#include <gal/e-table/e-cell-text.h>
#include "util/type-utils.h"
#include "m-cell-filter.h"

static void m_cell_filter_class_init (GtkObjectClass *object_class);
static void m_cell_filter_init (GtkObject *object);

GNOME_CLASS_BOILERPLATE (MCellFilter, m_cell_filter, ECellText, e_cell_text);

static char *
mcd_get_text (ECellText *cell, ETableModel *model, int col, int row)
{
	MCellFilter *mcf;
	gpointer value;

	mcf = (MCellFilter *) cell;
	
	value = e_table_model_value_at (model, col, row);

	return mcf->get_func (value);
}

static void
mcd_free_text (ECellText *cell, char *text)
{
	MCellFilter *mcf;

	mcf = (MCellFilter *) cell;
	if (mcf->free_func) {
		 mcf->free_func (text);
	}
}

static void
m_cell_filter_class_init (GtkObjectClass *object_class)
{
	ECellTextClass *ectc = (ECellTextClass *) object_class;

	ectc->get_text  = mcd_get_text;
	ectc->free_text = mcd_free_text;
}

static void
m_cell_filter_init (GtkObject *object)
{
}

ECell *
m_cell_filter_new (const char *fontname, GtkJustification justify,
		   MCellFilterGetFunc get_func, MCellFilterFreeFunc free_func)
{
	MCellFilter *mcd = gtk_type_new (m_cell_filter_get_type ());

	e_cell_text_construct (E_CELL_TEXT (mcd), fontname, justify);

	mcd->get_func = get_func;
	mcd->free_func = free_func;
	
	return (ECell *) mcd;
}

