/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 */

#ifndef __TASK_DIALOG_GUI_H__
#define __TASK_DIALOG_GUI_H__

#include <glib.h>
#include <gtk/gtktypeutils.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkwindow.h>
#include "util/corba-utils.h"

#define TASK_DIALOG_GUI_TYPE         (task_dialog_gui_get_type ())
#define TASK_DIALOG_GUI(o)           (GTK_CHECK_CAST ((o), TASK_DIALOG_GUI_TYPE, TaskDialogGui))
#define TASK_DIALOG_GUI_CLASS(k)     (GTK_CHECK_CLASS_CAST ((k), TASK_DIALOG_GUI_TYPE, TaskDialogGuiClass))
#define IS_TASK_DIALOG_GUI(o)        (GTK_CHECK_TYPE ((o), TASK_DIALOG_GUI_TYPE))
#define IS_TASK_DIALOG_GUI_CLASS(k)  (GTK_CHECK_CLASS_TYPE ((k), TASK_DIALOG_GUI_TYPE))

typedef struct _TaskDialogGui        TaskDialogGui;
typedef struct _TaskDialogGuiClass   TaskDialogGuiClass;
typedef struct _TaskDialogGuiPriv    TaskDialogGuiPriv;

struct _TaskDialogGui {
        GtkWindow            parent;
        
        TaskDialogGuiPriv   *priv;
};

struct _TaskDialogGuiClass {
        GtkWindowClass       parent_window;
        
        void (*task_updated)                  (TaskDialogGui        *gui,
					       GM_Task              *task);
        void (*dependency_added)              (TaskDialogGui        *gui,
					       GM_Id                 task1,
					       GM_Id                 task2);
        void (*dependency_removed)            (TaskDialogGui        *gui,
					       GM_Id                 task1,
					       GM_Id                 task2);
        void (*resource_allocated)            (TaskDialogGui        *gui,
					       GM_Id                 task,
					       GM_Id                 resource);
        void (*resource_deallocated)          (TaskDialogGui        *gui,
					       GM_Id                 task,
					       GM_Id                 resource);
	void (*note_changed)                  (TaskDialogGui        *gui,
					       GM_Id                 task,
					       gchar                *note);
};

GtkType     task_dialog_gui_get_type          (void);

GtkWidget  *task_dialog_gui_new               (void);

void        task_dialog_gui_update_task       (TaskDialogGui        *gui,
					       GM_Task              *task);

void        task_dialog_gui_add_resource      (TaskDialogGui        *gui,
					       GM_Resource          *res);

void        task_dialog_gui_update_resource   (TaskDialogGui        *gui,
					       GM_Resource          *res);

void        task_dialog_gui_remove_resource   (TaskDialogGui        *gui,
					       GM_Id                 id);

void        task_dialog_gui_set_allocation    (TaskDialogGui        *gui,
					       GM_Id                 id,
					       gboolean              alloc);

void        task_dialog_gui_add_group         (TaskDialogGui        *gui,
					       GM_ResourceGroup     *group);

void        task_dialog_gui_remove_group      (TaskDialogGui        *gui,
					       GM_Id                 gid);

void        task_dialog_gui_update_note       (TaskDialogGui        *gui,
					       gchar                *note);
void        task_dialog_gui_show_page         (TaskDialogGui        *gui,
					       GM_TaskDialogPage     page);

#endif /* __TASK_DIALOG_GUI_H__ */
