/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* 
 * Author : 
 *  Damon Chaplin <damon@ximian.com>
 *
 * Copyright 1999, Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */
/*
 * This code was taken from Evolution, and was rehacked to work
 * with MrProject by Thomas Nyberg <thomas@codefactory.se>
 */
/*
 * EWeekViewMainItem - displays the background grid and dates for the Week and
 * Month calendar views.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <glib.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h> 
#include <stdio.h>
#include "month-view-main-item.h"
#include "util/type-utils.h"

#define DEBUG 1
#include "util/debug.h"

static void month_view_main_item_class_init	(MonthViewMainItemClass *klass);
static void month_view_main_item_init		(MonthViewMainItem *self);

static void month_view_main_item_set_arg	(GtkObject	 *o,
						 GtkArg		 *arg,
						 guint		  arg_id);
static void month_view_main_item_update	(GnomeCanvasItem *item,
						 double		 *affine,
						 ArtSVP		 *clip_path,
						 int		  flags);
static void month_view_main_item_draw		(GnomeCanvasItem *item,
						 GdkDrawable	 *drawable,
						 int		  x,
						 int		  y,
						 int		  width,
						 int		  height);
static void month_view_main_item_draw_day	(MonthViewMainItem *self,
						 gint		   day,
						 gboolean          shaded,
						 GDate		  *date,
						 GdkDrawable       *drawable,
						 gint		   x,
						 gint		   y,
						 gint		   width,
						 gint		   height);
static double month_view_main_item_point	(GnomeCanvasItem *item,
						 double		  x,
						 double		  y,
						 int		  cx,
						 int		  cy,
						 GnomeCanvasItem **actual_item);


static GnomeCanvasItemClass *parent_class;

/* The arguments we take */
enum {
	ARG_0,
	ARG_MONTH_VIEW
};

GNOME_CLASS_BOILERPLATE (MonthViewMainItem, month_view_main_item,
			 GnomeCanvasItem, gnome_canvas_item);

static void
month_view_main_item_class_init (MonthViewMainItemClass *klass)
{
	GtkObjectClass  *object_class;
	GnomeCanvasItemClass *item_class;

	parent_class = gtk_type_class (gnome_canvas_item_get_type());

	object_class = (GtkObjectClass *) klass;
	item_class = (GnomeCanvasItemClass *) klass;

	gtk_object_add_arg_type ("MonthViewMainItem::month_view",
				 GTK_TYPE_POINTER, GTK_ARG_WRITABLE,
				 ARG_MONTH_VIEW);

	object_class->set_arg = month_view_main_item_set_arg;

	/* GnomeCanvasItem method overrides */
	item_class->update      = month_view_main_item_update;
	item_class->draw        = month_view_main_item_draw;
	item_class->point       = month_view_main_item_point;
}


static void
month_view_main_item_init (MonthViewMainItem *self)
{
	self->month_view = NULL;
}


static void
month_view_main_item_set_arg (GtkObject *o, GtkArg *arg, guint arg_id)
{
	GnomeCanvasItem *item;
	MonthViewMainItem *self;

	item = GNOME_CANVAS_ITEM (o);
	self = MONTH_VIEW_MAIN_ITEM (o);
	
	switch (arg_id){
	case ARG_MONTH_VIEW:
		self->month_view = GTK_VALUE_POINTER (*arg);
		break;
	}
}


static void
month_view_main_item_update (GnomeCanvasItem *item,
			      double	      *affine,
			      ArtSVP	      *clip_path,
			      int	       flags)
{
	if (GNOME_CANVAS_ITEM_CLASS (parent_class)->update)
		(* GNOME_CANVAS_ITEM_CLASS (parent_class)->update) (item, affine, clip_path, flags);

	/* The item covers the entire canvas area. */
	item->x1 = 0;
	item->y1 = 0;
	item->x2 = INT_MAX;
	item->y2 = INT_MAX;
}


/*
 * DRAWING ROUTINES - functions to paint the canvas item.
 */

static void
month_view_main_item_draw (GnomeCanvasItem  *canvas_item,
			    GdkDrawable      *drawable,
			    int		      x,
			    int		      y,
			    int		      width,
			    int		      height)
{
	MonthViewMainItem *self;
	MonthView *month_view;
	GDate date;
	gint num_days, day, day_x, day_y, day_w, day_h;
	gboolean shaded;

	d(puts(__FUNCTION__));
#if 0
	g_print ("In e_week_view_main_item_draw %i,%i %ix%i\n",
		 x, y, width, height);
#endif

	self = MONTH_VIEW_MAIN_ITEM (canvas_item);
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_MONTH_VIEW_MAIN_ITEM (self));

	month_view = self->month_view;
	g_return_if_fail (month_view != NULL);
	g_return_if_fail (IS_MONTH_VIEW (month_view));

	/* Step through each of the days. */
	date = month_view->first_day_shown;

	/* If no date has been set, we just use Dec 1999/January 2000. */
	if (!g_date_valid (&date)) {
		g_date_set_dmy (&date, 27, 12, 1999);
	}

	num_days = month_view->weeks_shown * 7;

	shaded = !g_date_is_first_of_month (&date);

	for (day = 0; day < num_days; day++) {
		month_view_get_day_position (month_view, day,
					      &day_x, &day_y,
					      &day_w, &day_h);
		/* Skip any days which are outside the area. */
		if (day_x < x + width && day_x + day_w >= x
		    && day_y < y + height && day_y + day_h >= y) {

			month_view_main_item_draw_day (self, day, shaded, &date,
							drawable,
							day_x - x, day_y - y,
							day_w, day_h);
		}
		if (g_date_is_last_of_month (&date)) {
			shaded = !shaded;
		}
		g_date_add_days (&date, 1);
	}
}


static void
month_view_main_item_draw_day (MonthViewMainItem  *self,
			       gint		   day,
			       gboolean            shaded,
			       GDate		  *date,
			       GdkDrawable       *drawable,
			       gint		   x,
			       gint		   y,
			       gint		   width,
			       gint		   height)
{
	MonthView *month_view;
	GtkStyle *style;
	GdkGC *gc;
	GdkFont *font;
	gint right_edge, bottom_edge, date_width, date_x, line_y;
	gboolean show_day_name, show_month_name;
	gchar buffer[128], *format_string;
	gint month, day_of_month, max_width;
	GdkColor *bg_color;

	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_MONTH_VIEW_MAIN_ITEM (self));
#if 0
	g_print ("Drawing Day:%i at %i,%i\n", day, x, y);
#endif
	month_view = self->month_view;
	g_return_if_fail (month_view != NULL);
	g_return_if_fail (IS_MONTH_VIEW (month_view));

	style = GTK_WIDGET (month_view)->style;
	font = style->font;
	gc = month_view->main_gc;

	g_return_if_fail (gc != NULL);

	month = g_date_month (date);
	day_of_month = g_date_day (date);
	line_y = y + MONTH_VIEW_DATE_T_PAD + font->ascent
		+ font->descent	+ MONTH_VIEW_DATE_LINE_T_PAD;

	/* Draw the background of the day. In the month view odd months are
	   one color and even months another, so you can easily see when each
	   month starts (defaults are white for odd - January, March, ... and
	   light gray for even). In the week view the background is always the
	   same color, the color used for the odd months in the month view. */
	/*	if ((month % 2 == 0)) */
	if (shaded)
		bg_color = &month_view->colors[MONTH_VIEW_COLOR_EVEN_MONTHS];
	else
		bg_color = &month_view->colors[MONTH_VIEW_COLOR_ODD_MONTHS];

	gdk_gc_set_foreground (gc, bg_color);
	gdk_draw_rectangle (drawable, gc, TRUE, x, y, width, height);

	/* Draw the lines on the right and bottom of the cell. The canvas is
	   sized so that the lines on the right & bottom edges will be off the
	   edge of the canvas, so we don't have to worry about them. */
	right_edge = x + width - 1;
	bottom_edge = y + height - 1;

	gdk_gc_set_foreground (gc, &month_view->colors[MONTH_VIEW_COLOR_GRID]);
	gdk_draw_line (drawable, gc,
		       right_edge, y, right_edge, bottom_edge);
	gdk_draw_line (drawable, gc,
		       x, bottom_edge, right_edge, bottom_edge);

	/* Display the date in the top of the cell.
	   In the week view, display the long format "10 January" in all cells,
	   or abbreviate it to "10 Jan" or "10" if that doesn't fit.
	   In the month view, only use the long format for the first cell and
	   the 1st of each month, otherwise use "10". */
	show_day_name = FALSE;
	show_month_name = FALSE;
	if (day == 0 || day_of_month == 1) {
		show_month_name = TRUE;
	}

	/* Now find the longest form of the date that will fit. */
	max_width = width - 4;
	format_string = NULL;
	if (show_day_name) {
		if (month_view->max_day_width + month_view->digit_width * 2
		    + month_view->space_width * 2
		    + month_view->month_widths[month - 1] < max_width)
			/* strftime format %A = full weekday name, %d = day of
			   month, %B = full month name. You can change the
			   order but don't change the specifiers or add
			   anything. */
			format_string = _("%A %d %B");
		else if (month_view->max_abbr_day_width
			 + month_view->digit_width * 2
			 + month_view->space_width * 2
			 + month_view->abbr_month_widths[month - 1] < max_width)
			/* strftime format %a = abbreviated weekday name,
			   %d = day of month, %b = abbreviated month name.
			   You can change the order but don't change the
			   specifiers or add anything. */
			format_string = _("%a %d %b");
	}
	if (!format_string && show_month_name) {
		if (month_view->digit_width * 2 + month_view->space_width
		    + month_view->month_widths[month - 1] < max_width)
			/* strftime format %d = day of month, %B = full
			   month name. You can change the order but don't
			   change the specifiers or add anything. */
			format_string = _("%d %B");
		else if (month_view->digit_width * 2 + month_view->space_width
		    + month_view->abbr_month_widths[month - 1] < max_width)
			/* strftime format %d = day of month, %b = abbreviated
			   month name. You can change the order but don't
			   change the specifiers or add anything. */
			format_string = _("%d %b");
	}

	g_date_strftime (buffer, sizeof (buffer),
			 format_string ? format_string : "%d", date);
	date_width = gdk_string_width (font, buffer);
	date_x = x + width - date_width - MONTH_VIEW_DATE_R_PAD;
	date_x = MAX (date_x, x + 1);

	gdk_gc_set_foreground (gc, &month_view->colors[MONTH_VIEW_COLOR_DATES]);
	gdk_draw_string (drawable, font, gc,
			 date_x, y + MONTH_VIEW_DATE_T_PAD + font->ascent,
			 buffer);
}




/* This is supposed to return the nearest item the the point and the distance.
   Since we are the only item we just return ourself and 0 for the distance.
   This is needed so that we get button/motion events. */
static double
month_view_main_item_point (GnomeCanvasItem *item, double x, double y,
			     int cx, int cy,
			     GnomeCanvasItem **actual_item)
{
	*actual_item = item;
	return 0.0;
}


