/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 Anders Carlsson <andersca@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Anders Carlsson
 */

#ifndef __CALENDAR_COMPONENT_H__
#define __CALENDAR_COMPONENT_H__

#include <gtk/gtktypeutils.h>
#include "client/components/shell-component/shell-component.h"

#define CALENDAR_COMPONENT_TYPE        (calendar_component_get_type ())
#define CALENDAR_COMPONENT(o)          (GTK_CHECK_CAST ((o), CALENDAR_COMPONENT_TYPE, CalendarComponent))
#define CALENDAR_COMPONENT_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), CALENDAR_COMPONENT_TYPE, CalendarComponentClass))
#define IS_CALENDAR_COMPONENT(o)       (GTK_CHECK_TYPE ((o), CALENDAR_COMPONENT_TYPE))
#define IS_CALENDAR_COMPONENT_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), CALENDAR_COMPONENT_TYPE))

typedef struct _CalendarComponentPriv CalendarComponentPriv;
typedef struct _CalendarComponent CalendarComponent;
typedef struct _CalendarComponentClass CalendarComponentClass;

struct _CalendarComponent {
	ShellComponent           parent;
	CalendarComponentPriv   *priv;
};

struct _CalendarComponentClass {
	ShellComponentClass      parent_class;
};


GtkType  calendar_component_get_type  (void);


#endif /* __CALENDAR_COMPONENT_H__ */

