/*
 * Decompiled with CFR 0.152.
 */
package viewer.convertor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class ProgressAction
implements ActionListener {
    public static final int MIN_PROGRESS_VALUE = 0;
    public static final int MAX_PROGRESS_VALUE = 100;
    private static final double KILOBYTE = 1024.0;
    private static DecimalFormat fmt = null;
    private JTextField text_fld;
    private JProgressBar progress_bar;
    private File infile;
    private File outfile;
    private long infile_size;
    private long outfile_size;

    public ProgressAction(JTextField jTextField, JProgressBar jProgressBar) {
        this.text_fld = jTextField;
        if (this.text_fld != null) {
            fmt = (DecimalFormat)NumberFormat.getInstance();
            fmt.applyPattern("#,###,###,##0.0");
            this.text_fld.setColumns(18);
            this.text_fld.setHorizontalAlignment(4);
        }
        this.progress_bar = jProgressBar;
        if (this.progress_bar != null) {
            this.progress_bar.setMinimum(0);
            this.progress_bar.setMaximum(100);
        }
        this.infile = null;
        this.outfile = null;
        this.infile_size = 0L;
        this.outfile_size = 0L;
    }

    public void initialize(File file, File file2) {
        this.infile = file;
        this.outfile = file2;
        if (this.text_fld != null) {
            this.text_fld.setText(fmt.format(0.0) + " KB");
        }
        if (this.progress_bar != null) {
            this.progress_bar.setValue(0);
            this.infile_size = this.infile.length();
        }
    }

    public void finish() {
        if (this.progress_bar != null) {
            this.progress_bar.setValue(100);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.outfile_size = this.outfile.length();
        if (this.text_fld != null) {
            this.text_fld.setText(fmt.format((double)this.outfile_size / 1024.0) + " KB");
        }
        if (this.progress_bar != null) {
            int n = this.progress_bar.getMinimum();
            int n2 = this.progress_bar.getMaximum();
            double d = (double)(n2 - n) * (double)this.outfile_size / (double)this.infile_size + (double)n;
            this.progress_bar.setValue((int)d);
        }
    }
}

