/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.io.DataIO;
import base.io.MixedDataIO;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import logformat.slog2.TreeDirValue;
import logformat.slog2.TreeNodeID;

public class TreeDir
extends TreeMap
implements DataIO,
MixedDataIO {
    private TreeNodeID root = new TreeNodeID(0, 0);

    public TreeDir() {
        super(TreeNodeID.INCRE_INDEX_ORDER);
    }

    public TreeNodeID getTreeRootID() {
        return this.root;
    }

    public void put(TreeNodeID treeNodeID, TreeDirValue treeDirValue) {
        super.put(treeNodeID, treeDirValue);
        if (treeNodeID.isPossibleRoot() && treeNodeID.depth > this.root.depth) {
            this.root = new TreeNodeID(treeNodeID);
        }
    }

    public TreeDirValue get(TreeNodeID treeNodeID) {
        return (TreeDirValue)super.get(treeNodeID);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(super.size());
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TreeNodeID treeNodeID = (TreeNodeID)entry.getKey();
            TreeDirValue treeDirValue = (TreeDirValue)entry.getValue();
            treeNodeID.writeObject(dataOutput);
            treeDirValue.writeObject(dataOutput);
        }
    }

    public void writeObject(MixedDataOutput mixedDataOutput) throws IOException {
        this.writeObject((DataOutput)mixedDataOutput);
    }

    public TreeDir(DataInput dataInput) throws IOException {
        this();
        this.readObject(dataInput);
    }

    public void readObject(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            TreeNodeID treeNodeID = new TreeNodeID(dataInput);
            TreeDirValue treeDirValue = new TreeDirValue(dataInput);
            this.put(treeNodeID, treeDirValue);
        }
    }

    public void readObject(MixedDataInput mixedDataInput) throws IOException {
        this.readObject((DataInput)mixedDataInput);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\t SLOG-2 Tree Directory\n");
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TreeNodeID treeNodeID = (TreeNodeID)entry.getKey();
            TreeDirValue treeDirValue = (TreeDirValue)entry.getValue();
            stringBuffer.append(treeNodeID + " -> " + treeDirValue + "\n");
        }
        return stringBuffer.toString();
    }
}

