/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Coord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;

public class TimeBoundingBox {
    public static final TimeBoundingBox ALL_TIMES = new TimeBoundingBox(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Order INCRE_STARTTIME_ORDER = new IncreasingStarttimeOrder();
    public static final Order DECRE_STARTTIME_ORDER = new DecreasingStarttimeOrder();
    public static final Order INCRE_FINALTIME_ORDER = new IncreasingFinaltimeOrder();
    public static final Order DECRE_FINALTIME_ORDER = new DecreasingFinaltimeOrder();
    public static final int BYTESIZE = 16;
    private double earliest_time;
    private double latest_time;

    public TimeBoundingBox() {
        this.earliest_time = Double.POSITIVE_INFINITY;
        this.latest_time = Double.NEGATIVE_INFINITY;
    }

    public TimeBoundingBox(TimeBoundingBox timeBoundingBox) {
        this.earliest_time = timeBoundingBox.earliest_time;
        this.latest_time = timeBoundingBox.latest_time;
    }

    public TimeBoundingBox(Coord[] coordArray) {
        if (coordArray != null) {
            this.earliest_time = this.latest_time = coordArray[0].time;
            for (int i = 1; i < coordArray.length; ++i) {
                this.affectEarliestTime(coordArray[i].time);
                this.affectLatestTime(coordArray[i].time);
            }
        } else {
            this.earliest_time = Double.POSITIVE_INFINITY;
            this.latest_time = Double.NEGATIVE_INFINITY;
        }
    }

    private TimeBoundingBox(double d, double d2) {
        this.earliest_time = d;
        this.latest_time = d2;
    }

    public void reinitialize() {
        this.earliest_time = Double.POSITIVE_INFINITY;
        this.latest_time = Double.NEGATIVE_INFINITY;
    }

    public void affectTimeBounds(TimeBoundingBox timeBoundingBox) {
        this.affectEarliestTime(timeBoundingBox.getEarliestTime());
        this.affectLatestTime(timeBoundingBox.getLatestTime());
    }

    public void affectTimeBounds(Coord coord) {
        this.affectEarliestTime(coord.time);
        this.affectLatestTime(coord.time);
    }

    public void affectTimeBounds(Coord[] coordArray) {
        for (int i = 0; i < coordArray.length; ++i) {
            this.affectEarliestTime(coordArray[i].time);
            this.affectLatestTime(coordArray[i].time);
        }
    }

    public void affectEarliestTime(double d) {
        if (d < this.earliest_time) {
            this.earliest_time = d;
        }
    }

    public void setEarliestTime(double d) {
        this.earliest_time = d;
    }

    public double getEarliestTime() {
        return this.earliest_time;
    }

    public void affectLatestTime(double d) {
        if (d > this.latest_time) {
            this.latest_time = d;
        }
    }

    public void setLatestTime(double d) {
        this.latest_time = d;
    }

    public double getLatestTime() {
        return this.latest_time;
    }

    public double getBorderTime(boolean bl) {
        if (bl) {
            return this.earliest_time;
        }
        return this.latest_time;
    }

    public void setLatestFromEarliest(double d) {
        this.latest_time = this.earliest_time + d;
    }

    public void setEarliestFromLatest(double d) {
        this.earliest_time = this.latest_time - d;
    }

    public boolean isTimeOrdered() {
        return this.earliest_time <= this.latest_time;
    }

    public boolean remove(TimeBoundingBox timeBoundingBox) {
        if (this.earliest_time == timeBoundingBox.earliest_time) {
            this.earliest_time = timeBoundingBox.latest_time;
            return true;
        }
        if (this.latest_time == timeBoundingBox.latest_time) {
            this.latest_time = timeBoundingBox.earliest_time;
            return true;
        }
        return false;
    }

    public boolean covers(TimeBoundingBox timeBoundingBox) {
        return this.earliest_time <= timeBoundingBox.earliest_time && timeBoundingBox.latest_time <= this.latest_time;
    }

    public boolean overlaps(TimeBoundingBox timeBoundingBox) {
        return this.earliest_time <= timeBoundingBox.latest_time && timeBoundingBox.earliest_time <= this.latest_time;
    }

    public boolean disjoints(TimeBoundingBox timeBoundingBox) {
        return this.latest_time < timeBoundingBox.earliest_time || timeBoundingBox.latest_time < this.earliest_time;
    }

    public boolean contains(double d) {
        return this.earliest_time <= d && d <= this.latest_time;
    }

    public boolean equals(TimeBoundingBox timeBoundingBox) {
        return this.earliest_time == timeBoundingBox.earliest_time && this.latest_time == timeBoundingBox.latest_time;
    }

    public boolean containsWithinLeft(double d) {
        return this.earliest_time <= d && d < this.latest_time;
    }

    public boolean containsWithinRight(double d) {
        return this.earliest_time < d && d <= this.latest_time;
    }

    public TimeBoundingBox getIntersection(TimeBoundingBox timeBoundingBox) {
        if (this.overlaps(timeBoundingBox)) {
            double d = this.earliest_time < timeBoundingBox.earliest_time ? timeBoundingBox.earliest_time : this.earliest_time;
            double d2 = this.latest_time < timeBoundingBox.latest_time ? this.latest_time : timeBoundingBox.latest_time;
            TimeBoundingBox timeBoundingBox2 = new TimeBoundingBox();
            timeBoundingBox2.earliest_time = d;
            timeBoundingBox2.latest_time = d2;
            return timeBoundingBox2;
        }
        return null;
    }

    public double getIntersectionDuration(TimeBoundingBox timeBoundingBox) {
        if (this.overlaps(timeBoundingBox)) {
            double d;
            double d2 = this.latest_time < timeBoundingBox.latest_time ? this.latest_time : timeBoundingBox.latest_time;
            double d3 = d2 - (d = this.earliest_time < timeBoundingBox.earliest_time ? timeBoundingBox.earliest_time : this.earliest_time);
            if (d3 > 0.0) {
                return d3;
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getDuration() {
        return this.latest_time - this.earliest_time;
    }

    public void setZeroDuration(double d) {
        this.earliest_time = d;
        this.latest_time = d;
    }

    public static void writeObject(TimeBoundingBox timeBoundingBox, DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(timeBoundingBox.earliest_time);
        dataOutput.writeDouble(timeBoundingBox.latest_time);
    }

    public static void readObject(TimeBoundingBox timeBoundingBox, DataInput dataInput) throws IOException {
        timeBoundingBox.earliest_time = dataInput.readDouble();
        timeBoundingBox.latest_time = dataInput.readDouble();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.earliest_time);
        dataOutput.writeDouble(this.latest_time);
    }

    public TimeBoundingBox(DataInput dataInput) throws IOException {
        this.readObject(dataInput);
    }

    public void readObject(DataInput dataInput) throws IOException {
        this.earliest_time = dataInput.readDouble();
        this.latest_time = dataInput.readDouble();
    }

    public String toString() {
        return "TimeBBox(" + this.earliest_time + "," + this.latest_time + ")";
    }

    public static final void main(String[] stringArray) {
        TimeBoundingBox timeBoundingBox = new TimeBoundingBox();
        System.out.println(timeBoundingBox);
        if (INCRE_STARTTIME_ORDER.equals(DECRE_STARTTIME_ORDER)) {
            System.out.println("INCRE_STARTTIME_ORDER=DECRE_STARTTIME_ORDER");
        } else {
            System.out.println("INCRE_STARTTIME_ORDER!DECRE_STARTTIME_ORDER");
        }
        if (INCRE_STARTTIME_ORDER.equals(INCRE_FINALTIME_ORDER)) {
            System.out.println("INCRE_STARTTIME_ORDER=INCRE_FINALTIME_ORDER");
        } else {
            System.out.println("INCRE_STARTTIME_ORDER!INCRE_FINALTIME_ORDER");
        }
        if (INCRE_STARTTIME_ORDER.equals(DECRE_FINALTIME_ORDER)) {
            System.out.println("INCRE_STARTTIME_ORDER=DECRE_FINALTIME_ORDER");
        } else {
            System.out.println("INCRE_STARTTIME_ORDER!DECRE_FINALTIME_ORDER");
        }
        if (INCRE_STARTTIME_ORDER.equals(INCRE_STARTTIME_ORDER)) {
            System.out.println("INCRE_STARTTIME_ORDER=INCRE_STARTTIME_ORDER");
        } else {
            System.out.println("INCRE_STARTTIME_ORDER!INCRE_STARTTIME_ORDER");
        }
        IncreasingStarttimeOrder increasingStarttimeOrder = new IncreasingStarttimeOrder();
        if (INCRE_STARTTIME_ORDER.equals(increasingStarttimeOrder)) {
            System.out.println("INCRE_STARTTIME_ORDER=tmp_order");
        } else {
            System.out.println("INCRE_STARTTIME_ORDER!tmp_order");
        }
    }

    private static class DecreasingFinaltimeOrder
    implements Order {
        private DecreasingFinaltimeOrder() {
        }

        public int compare(Object object, Object object2) {
            TimeBoundingBox timeBoundingBox = (TimeBoundingBox)object;
            TimeBoundingBox timeBoundingBox2 = (TimeBoundingBox)object2;
            if (timeBoundingBox.latest_time != timeBoundingBox2.latest_time) {
                return timeBoundingBox.latest_time > timeBoundingBox2.latest_time ? -1 : 1;
            }
            if (timeBoundingBox.earliest_time != timeBoundingBox2.earliest_time) {
                return timeBoundingBox.earliest_time < timeBoundingBox2.earliest_time ? -1 : 1;
            }
            return 0;
        }

        public boolean isIncreasingTimeOrdered() {
            return false;
        }

        public boolean isStartTimeOrdered() {
            return false;
        }

        public String toString() {
            return "DECRE_FINALTIME_ORDER";
        }
    }

    private static class IncreasingFinaltimeOrder
    implements Order {
        private IncreasingFinaltimeOrder() {
        }

        public int compare(Object object, Object object2) {
            TimeBoundingBox timeBoundingBox = (TimeBoundingBox)object;
            TimeBoundingBox timeBoundingBox2 = (TimeBoundingBox)object2;
            if (timeBoundingBox.latest_time != timeBoundingBox2.latest_time) {
                return timeBoundingBox.latest_time < timeBoundingBox2.latest_time ? -1 : 1;
            }
            if (timeBoundingBox.earliest_time != timeBoundingBox2.earliest_time) {
                return timeBoundingBox.earliest_time > timeBoundingBox2.earliest_time ? -1 : 1;
            }
            return 0;
        }

        public boolean isIncreasingTimeOrdered() {
            return true;
        }

        public boolean isStartTimeOrdered() {
            return false;
        }

        public String toString() {
            return "INCRE_FINALTIME_ORDER";
        }
    }

    private static class DecreasingStarttimeOrder
    implements Order {
        private DecreasingStarttimeOrder() {
        }

        public int compare(Object object, Object object2) {
            TimeBoundingBox timeBoundingBox = (TimeBoundingBox)object;
            TimeBoundingBox timeBoundingBox2 = (TimeBoundingBox)object2;
            if (timeBoundingBox.earliest_time != timeBoundingBox2.earliest_time) {
                return timeBoundingBox.earliest_time > timeBoundingBox2.earliest_time ? -1 : 1;
            }
            if (timeBoundingBox.latest_time != timeBoundingBox2.latest_time) {
                return timeBoundingBox.latest_time < timeBoundingBox2.latest_time ? -1 : 1;
            }
            return 0;
        }

        public boolean isIncreasingTimeOrdered() {
            return false;
        }

        public boolean isStartTimeOrdered() {
            return true;
        }

        public String toString() {
            return "DECRE_STARTTIME_ORDER";
        }
    }

    private static class IncreasingStarttimeOrder
    implements Order {
        private IncreasingStarttimeOrder() {
        }

        public int compare(Object object, Object object2) {
            TimeBoundingBox timeBoundingBox = (TimeBoundingBox)object;
            TimeBoundingBox timeBoundingBox2 = (TimeBoundingBox)object2;
            if (timeBoundingBox.earliest_time != timeBoundingBox2.earliest_time) {
                return timeBoundingBox.earliest_time < timeBoundingBox2.earliest_time ? -1 : 1;
            }
            if (timeBoundingBox.latest_time != timeBoundingBox2.latest_time) {
                return timeBoundingBox.latest_time > timeBoundingBox2.latest_time ? -1 : 1;
            }
            return 0;
        }

        public boolean isIncreasingTimeOrdered() {
            return true;
        }

        public boolean isStartTimeOrdered() {
            return true;
        }

        public String toString() {
            return "INCRE_STARTTIME_ORDER";
        }
    }

    public static interface Order
    extends Comparator {
        public boolean isIncreasingTimeOrdered();

        public boolean isStartTimeOrdered();

        public String toString();
    }
}

