/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;

public class BasicInternalFrameTitlePane
extends JComponent {
    protected JMenuBar menuBar;
    protected JButton iconButton;
    protected JButton maxButton;
    protected JButton closeButton;
    protected JMenu windowMenu;
    protected JInternalFrame frame;
    protected Color selectedTitleColor;
    protected Color selectedTextColor;
    protected Color notSelectedTitleColor;
    protected Color notSelectedTextColor;
    protected Icon maxIcon;
    protected Icon minIcon;
    protected Icon iconIcon;
    protected Icon closeIcon;
    protected PropertyChangeListener propertyChangeListener;
    protected Action closeAction;
    protected Action maximizeAction;
    protected Action iconifyAction;
    protected Action restoreAction;
    protected Action moveAction;
    protected Action sizeAction;
    protected static final String CLOSE_CMD = "Close";
    protected static final String ICONIFY_CMD = "Minimize";
    protected static final String RESTORE_CMD = "Restore";
    protected static final String MAXIMIZE_CMD = "Maximize";
    protected static final String MOVE_CMD = "Move";
    protected static final String SIZE_CMD = "Size";
    static /* synthetic */ Class class$javax$swing$JInternalFrame;

    public BasicInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        this.frame = jInternalFrame;
        this.installTitlePane();
    }

    public void addNotify() {
        super.addNotify();
        this.addSystemMenuItems(this.windowMenu);
        this.enableActions();
    }

    protected void addSubComponents() {
        this.add(this.menuBar);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected void addSystemMenuItems(JMenu jMenu) {
        JMenuItem jMenuItem = jMenu.add(this.restoreAction);
        jMenuItem.setMnemonic('R');
        jMenuItem = jMenu.add(this.moveAction);
        jMenuItem.setMnemonic('M');
        jMenuItem = jMenu.add(this.sizeAction);
        jMenuItem.setMnemonic('S');
        jMenuItem = jMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic('n');
        jMenuItem = jMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic('x');
        jMenu.add(new JSeparator());
        jMenuItem = jMenu.add(this.closeAction);
        jMenuItem.setMnemonic('C');
    }

    protected void assembleSystemMenu() {
        this.menuBar = this.createSystemMenuBar();
        this.windowMenu = this.createSystemMenu();
        this.menuBar.add(this.windowMenu);
        this.enableActions();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void createActions() {
        this.maximizeAction = new MaximizeAction();
        this.iconifyAction = new IconifyAction();
        this.closeAction = new CloseAction();
        this.restoreAction = new RestoreAction();
        this.moveAction = new MoveAction();
        this.sizeAction = new SizeAction();
    }

    protected void createButtons() {
        this.iconButton = new NoFocusButton();
        this.iconButton.addActionListener(this.iconifyAction);
        this.maxButton = new NoFocusButton();
        this.maxButton.addActionListener(this.maximizeAction);
        this.closeButton = new NoFocusButton();
        this.closeButton.addActionListener(this.closeAction);
        this.setButtonIcons();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected JMenu createSystemMenu() {
        return new JMenu("    ");
    }

    protected JMenuBar createSystemMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setBorderPainted(false);
        return this.menuBar;
    }

    protected void enableActions() {
        this.restoreAction.setEnabled(this.frame.isMaximum() || this.frame.isIcon());
        this.maximizeAction.setEnabled(this.frame.isMaximizable() && !this.frame.isMaximum());
        this.iconifyAction.setEnabled(this.frame.isIconifiable() && !this.frame.isIcon());
        this.closeAction.setEnabled(this.frame.isClosable());
        this.sizeAction.setEnabled(false);
        this.moveAction.setEnabled(false);
    }

    protected void installDefaults() {
        this.maxIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
        this.minIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
        this.iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
        this.closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
        this.selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
        this.selectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        this.notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        this.notSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.enableActions();
        this.setLayout(this.createLayout());
        this.assembleSystemMenu();
        this.createButtons();
        this.addSubComponents();
    }

    public void paintComponent(Graphics graphics) {
        boolean bl = this.frame.isSelected();
        if (bl) {
            graphics.setColor(this.selectedTitleColor);
        } else {
            graphics.setColor(this.notSelectedTitleColor);
        }
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.frame.getTitle() != null) {
            Font font = graphics.getFont();
            graphics.setFont(UIManager.getFont("InternalFrame.titleFont"));
            if (bl) {
                graphics.setColor(this.selectedTextColor);
            } else {
                graphics.setColor(this.notSelectedTextColor);
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight() - fontMetrics.getLeading();
            int n2 = (18 - n) / 2 + fontMetrics.getAscent() + fontMetrics.getLeading();
            graphics.drawString(this.frame.getTitle(), this.menuBar.getX() + this.menuBar.getWidth() + 2, n2);
            graphics.setFont(font);
        }
    }

    protected void postClosingEvent(JInternalFrame jInternalFrame) {
        InternalFrameEvent internalFrameEvent = new InternalFrameEvent(jInternalFrame, 25550);
        if ((class$javax$swing$JInternalFrame != null ? class$javax$swing$JInternalFrame : (class$javax$swing$JInternalFrame = BasicInternalFrameTitlePane.class$("javax.swing.JInternalFrame"))).getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(internalFrameEvent);
                return;
            }
            catch (SecurityException securityException) {}
        }
        jInternalFrame.dispatchEvent(internalFrameEvent);
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.windowMenu != null) {
            this.windowMenu.removeAll();
        }
        this.uninstallDefaults();
    }

    protected void setButtonIcons() {
        if (this.frame.isIcon()) {
            this.iconButton.setIcon(this.minIcon);
            this.maxButton.setIcon(this.maxIcon);
        } else if (this.frame.isMaximum()) {
            this.iconButton.setIcon(this.iconIcon);
            this.maxButton.setIcon(this.minIcon);
        } else {
            this.iconButton.setIcon(this.iconIcon);
            this.maxButton.setIcon(this.maxIcon);
        }
        this.closeButton.setIcon(this.closeIcon);
    }

    protected void showSystemMenu() {
        this.windowMenu.doClick();
    }

    protected void uninstallDefaults() {
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("selected".equals(string)) {
                BasicInternalFrameTitlePane.this.repaint();
                return;
            }
            if ("icon".equals(string) || "maximum".equals(string)) {
                BasicInternalFrameTitlePane.this.setButtonIcons();
                return;
            }
            BasicInternalFrameTitlePane.this.enableActions();
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            int n = BasicInternalFrameTitlePane.this.getWidth();
            int n2 = n - 16 - 2;
            BasicInternalFrameTitlePane.this.menuBar.setBounds(2, 1, 16, 16);
            if (BasicInternalFrameTitlePane.this.frame.isClosable()) {
                BasicInternalFrameTitlePane.this.closeButton.setBounds(n2, 2, 16, 14);
                n2 -= 16;
            } else if (BasicInternalFrameTitlePane.this.closeButton.getParent() != null) {
                BasicInternalFrameTitlePane.this.closeButton.getParent().remove(BasicInternalFrameTitlePane.this.closeButton);
            }
            if (BasicInternalFrameTitlePane.this.frame.isMaximizable()) {
                BasicInternalFrameTitlePane.this.maxButton.setBounds(n2 - 2, 2, 16, 14);
                n2 -= 18;
            } else if (BasicInternalFrameTitlePane.this.maxButton.getParent() != null) {
                BasicInternalFrameTitlePane.this.maxButton.getParent().remove(BasicInternalFrameTitlePane.this.maxButton);
            }
            if (BasicInternalFrameTitlePane.this.frame.isIconifiable()) {
                BasicInternalFrameTitlePane.this.iconButton.setBounds(n2, 2, 16, 14);
            } else if (BasicInternalFrameTitlePane.this.iconButton.getParent() != null) {
                BasicInternalFrameTitlePane.this.iconButton.getParent().remove(BasicInternalFrameTitlePane.this.iconButton);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(100, 18);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    public class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(BasicInternalFrameTitlePane.CLOSE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block2: {
                if (!BasicInternalFrameTitlePane.this.frame.isClosable()) break block2;
                try {
                    BasicInternalFrameTitlePane.this.frame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(BasicInternalFrameTitlePane.MAXIMIZE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block7: {
                if (!BasicInternalFrameTitlePane.this.frame.isMaximizable()) break block7;
                if (!BasicInternalFrameTitlePane.this.frame.isMaximum()) {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setMaximum(false);
                        if (BasicInternalFrameTitlePane.this.frame.isIconifiable() && BasicInternalFrameTitlePane.this.frame.isIcon()) {
                            BasicInternalFrameTitlePane.this.frame.setIcon(false);
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            }
        }
    }

    public class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(BasicInternalFrameTitlePane.ICONIFY_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block7: {
                if (!BasicInternalFrameTitlePane.this.frame.isIconifiable()) break block7;
                if (!BasicInternalFrameTitlePane.this.frame.isIcon()) {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setIcon(false);
                        if (BasicInternalFrameTitlePane.this.frame.isMaximizable() && BasicInternalFrameTitlePane.this.frame.isMaximum()) {
                            BasicInternalFrameTitlePane.this.frame.setMaximum(false);
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            }
        }
    }

    public class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(BasicInternalFrameTitlePane.RESTORE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block5: {
                block4: {
                    if (!BasicInternalFrameTitlePane.this.frame.isMaximizable() || !BasicInternalFrameTitlePane.this.frame.isMaximum()) break block4;
                    try {
                        BasicInternalFrameTitlePane.this.frame.setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break block5;
                }
                if (!BasicInternalFrameTitlePane.this.frame.isIconifiable() || !BasicInternalFrameTitlePane.this.frame.isIcon()) break block5;
                try {
                    BasicInternalFrameTitlePane.this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }
    }

    public class MoveAction
    extends AbstractAction {
        public MoveAction() {
            super(BasicInternalFrameTitlePane.MOVE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class SizeAction
    extends AbstractAction {
        public SizeAction() {
            super(BasicInternalFrameTitlePane.SIZE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class SystemMenuBar
    extends JMenuBar {
        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isOpaque() {
            return true;
        }

        public void paint(Graphics graphics) {
            Icon icon = BasicInternalFrameTitlePane.this.frame.getFrameIcon();
            if (icon == null) {
                icon = UIManager.getIcon("InternalFrame.icon");
            }
            if (icon != null) {
                if (icon instanceof ImageIcon && (icon.getIconWidth() > 16 || icon.getIconHeight() > 16)) {
                    Image image = ((ImageIcon)icon).getImage();
                    ((ImageIcon)icon).setImage(image.getScaledInstance(16, 16, 4));
                }
                icon.paintIcon(this, graphics, 0, 0);
            }
        }

        public void requestFocus() {
        }
    }

    private class NoFocusButton
    extends JButton {
        public NoFocusButton() {
            this.setFocusPainted(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isOpaque() {
            return true;
        }

        public void requestFocus() {
        }
    }
}

