/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.plaf.basic.Spinner;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

public class StringSpinner
extends Spinner {
    private String[] names;
    private String typed;

    public StringSpinner(int n, String string, String[] stringArray) {
        super(n, string);
        this.names = stringArray;
        this.setMinimum(0);
        this.setMaximum(stringArray.length - 1);
        this.setWrap(true);
        this.updateUI();
    }

    public String[] getNameArray() {
        return this.names;
    }

    public String getValueName() {
        return this.names[this.value];
    }

    public String getTypedString() {
        return this.typed;
    }

    private void resynctyped() {
        if (this.typed != null) {
            int n = this.typed.length();
            int n2 = 0;
            while (n2 < this.names.length) {
                if (this.typed.regionMatches(true, 0, this.names[n2], 0, n)) {
                    this.setValue(n2);
                    this.repaint();
                    return;
                }
                ++n2;
            }
            this.typed = n > 1 ? this.typed.substring(0, n - 1) : null;
            this.resynctyped();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isActionKey()) {
            switch (keyEvent.getKeyCode()) {
                case 40: {
                    this.setValue(this.value - 1);
                    return;
                }
                case 38: {
                    this.setValue(this.value + 1);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        char c = keyEvent.getKeyChar();
        if (c > ' ' && c < '\u007f') {
            this.typed = this.typed != null ? String.valueOf(this.typed) + (char)c : String.valueOf(c);
            this.resynctyped();
            return;
        }
        switch (c) {
            case '\b': 
            case '\u007f': {
                if (this.typed != null) {
                    this.typed = this.typed.length() <= 0 ? null : this.typed.substring(0, this.typed.length() - 1);
                }
                this.resynctyped();
                return;
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.typed = null;
        this.repaint();
        super.focusGained(focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.typed = null;
        this.repaint();
        super.focusLost(focusEvent);
    }
}

