/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.SystemEventQueueUtilities;
import com.sun.java.swing.Timer;

class TimerQueue
implements Runnable {
    Timer firstTimer;
    boolean running;
    private static final Object sharedInstanceKey = new StringBuffer("TimerQueue.sharedInstanceKey");
    private static final Object expiredTimersKey = new StringBuffer("TimerQueue.expiredTimersKey");
    static /* synthetic */ Class class$com$sun$java$swing$TimerQueue;

    public TimerQueue() {
        this.start();
    }

    public static TimerQueue sharedInstance() {
        Class clazz = class$com$sun$java$swing$TimerQueue != null ? class$com$sun$java$swing$TimerQueue : (class$com$sun$java$swing$TimerQueue = TimerQueue.class$("com.sun.java.swing.TimerQueue"));
        synchronized (clazz) {
            TimerQueue timerQueue = (TimerQueue)SwingUtilities.appContextGet(sharedInstanceKey);
            if (timerQueue == null) {
                timerQueue = new TimerQueue();
                SwingUtilities.appContextPut(sharedInstanceKey, timerQueue);
            }
            TimerQueue timerQueue2 = timerQueue;
            Object var2_3 = null;
            return timerQueue2;
        }
    }

    synchronized void start() {
        if (this.running) {
            throw new RuntimeException("Can't start a TimerQueue that is already running");
        }
        Thread thread = new Thread((Runnable)this, "TimerQueue");
        try {
            thread.setDaemon(true);
        }
        catch (SecurityException securityException) {}
        thread.start();
        this.running = true;
    }

    synchronized void stop() {
        this.running = false;
        this.notify();
    }

    synchronized void addTimer(Timer timer, long l) {
        if (timer.running) {
            return;
        }
        Timer timer2 = null;
        Timer timer3 = this.firstTimer;
        while (timer3 != null) {
            if (timer3.expirationTime > l) break;
            timer2 = timer3;
            timer3 = timer3.nextTimer;
        }
        if (timer2 == null) {
            this.firstTimer = timer;
        } else {
            timer2.nextTimer = timer;
        }
        timer.expirationTime = l;
        timer.nextTimer = timer3;
        timer.running = true;
        this.notify();
    }

    synchronized void removeTimer(Timer timer) {
        if (!timer.running) {
            return;
        }
        Timer timer2 = null;
        Timer timer3 = this.firstTimer;
        boolean bl = false;
        while (timer3 != null) {
            if (timer3 == timer) {
                bl = true;
                break;
            }
            timer2 = timer3;
            timer3 = timer3.nextTimer;
        }
        if (!bl) {
            return;
        }
        if (timer2 == null) {
            this.firstTimer = timer.nextTimer;
        } else {
            timer2.nextTimer = timer.nextTimer;
        }
        timer.expirationTime = 0L;
        timer.nextTimer = null;
        timer.running = false;
    }

    synchronized boolean containsTimer(Timer timer) {
        return timer.running;
    }

    synchronized long postExpiredTimers() {
        long l;
        do {
            Timer timer;
            if ((timer = this.firstTimer) == null) {
                return 0L;
            }
            long l2 = System.currentTimeMillis();
            l = timer.expirationTime - l2;
            if (l <= 0L) {
                try {
                    timer.post();
                }
                catch (SecurityException securityException) {}
                this.removeTimer(timer);
                if (timer.isRepeats()) {
                    this.addTimer(timer, l2 + (long)timer.getDelay());
                }
            }
            try {
                this.wait(1L);
            }
            catch (InterruptedException interruptedException) {}
        } while (l <= 0L);
        return l;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        try {
            while (true) {
                if (!this.running) {
                    return;
                }
                var1_1 = this.postExpiredTimers();
                try {
                    this.wait(var1_1);
                }
                catch (InterruptedException v0) {}
            }
        }
        catch (ThreadDeath var3_2) {
            this.running = false;
            var4_3 = this.firstTimer;
            ** while (var4_3 != null)
        }
lbl-1000:
        // 1 sources

        {
            var4_3.eventQueued = false;
            var4_3 = var4_3.nextTimer;
            continue;
        }
lbl18:
        // 1 sources

        SystemEventQueueUtilities.restartTimerQueueThread();
        throw var3_2;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TimerQueue (");
        Timer timer = this.firstTimer;
        while (timer != null) {
            stringBuffer.append(timer.toString());
            timer = timer.nextTimer;
            if (timer == null) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

