//
// System.Web.UI.TemplateControl.cs
//
// Authors:
//   Duncan Mak  (duncan@ximian.com)
//   Gonzalo Paniagua Javier (gonzalo@ximian.com)
//   Andreas Nahr (ClassDevelopment@A-SoftTech.com)
//
// (C) 2002 Ximian, Inc. (http://www.ximian.com)
// Copyright (C) 2005 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System.Collections;
using System.ComponentModel;
using System.Reflection;
using System.Security.Permissions;
using System.Web.Compilation;
using System.Web.Util;

namespace System.Web.UI {

	// CAS
	[AspNetHostingPermission (SecurityAction.LinkDemand, Level = AspNetHostingPermissionLevel.Minimal)]
	[AspNetHostingPermission (SecurityAction.InheritanceDemand, Level = AspNetHostingPermissionLevel.Minimal)]
#if NET_2_0
	public abstract class TemplateControl : Control, INamingContainer, IFilterResolutionService {
#else
	public abstract class TemplateControl : Control, INamingContainer {
#endif
		static object abortTransaction = new object ();
		static object commitTransaction = new object ();
		static object error = new object ();
		static string [] methodNames = { "Page_Init",
#if NET_2_0
						 "Page_PreInit",
						 "Page_PreLoad",
						 "Page_LoadComplete",
						 "Page_PreRenderComplete",
						 "Page_SaveStateComplete",
						 "Page_InitComplete",
#endif
						 "Page_Load",
						 "Page_DataBind",
						 "Page_PreRender",
						 "Page_Disposed",
						 "Page_Error",
						 "Page_Unload",
						 "Page_AbortTransaction",
						 "Page_CommitTransaction"};

		const BindingFlags bflags = BindingFlags.Public |
					    BindingFlags.NonPublic |
					    BindingFlags.Instance;

		#region Constructor
		protected TemplateControl ()
		{
			Construct ();
		}

		#endregion

		#region Properties
		[EditorBrowsable (EditorBrowsableState.Never)]
#if NET_2_0
		[Obsolete]
#endif
		protected virtual int AutoHandlers {
			get { return 0; }
			set { }
		}

		[EditorBrowsable (EditorBrowsableState.Never)]
		protected virtual bool SupportAutoEvents {
			get { return true; }
		}

		#endregion

		#region Methods

		protected virtual void Construct ()
		{
		}

		[MonoTODO ("Not implemented")]
		protected LiteralControl CreateResourceBasedLiteralControl (int offset,
										    int size,
										    bool fAsciiOnly)
		{
			return null;
		}

		internal void WireupAutomaticEvents ()
		{
			if (!SupportAutoEvents || !AutoEventWireup)
				return;

			Type type = GetType ();
			foreach (string methodName in methodNames) {
				MethodInfo method = type.GetMethod (methodName, bflags);
				if (method == null)
					continue;

				if (method.DeclaringType != type) {
					if (!method.IsPublic && !method.IsFamilyOrAssembly &&
					    !method.IsFamilyAndAssembly && !method.IsFamily)
						continue;
				}

				if (method.ReturnType != typeof (void))
					continue;

				ParameterInfo [] parms = method.GetParameters ();
				int length = parms.Length;
				bool noParams = (length == 0);
				if (!noParams && (length != 2 ||
				    parms [0].ParameterType != typeof (object) ||
				    parms [1].ParameterType != typeof (EventArgs)))
				    continue;

				int pos = methodName.IndexOf ("_");
				string eventName = methodName.Substring (pos + 1);
				EventInfo evt = type.GetEvent (eventName);
				if (evt == null) {
					/* This should never happen */
					continue;
				}

				if (noParams) {
					NoParamsInvoker npi = new NoParamsInvoker (this, methodName);
					evt.AddEventHandler (this, npi.FakeDelegate);
				} else {
					evt.AddEventHandler (this, Delegate.CreateDelegate (
							typeof (EventHandler), this, methodName));
				}
			}
		}

		[EditorBrowsable (EditorBrowsableState.Never)]
		protected virtual void FrameworkInitialize ()
		{
		}

		Type GetTypeFromControlPath (string virtualPath)
		{
			if (virtualPath == null)
				throw new ArgumentNullException ("virtualPath");

			string vpath = UrlUtils.Combine (TemplateSourceDirectory, virtualPath);
			string realpath = Context.Request.MapPath (vpath);
			return UserControlParser.GetCompiledType (vpath, realpath, Context);
		}

		public Control LoadControl (string virtualPath)
		{
#if NET_2_0
			if (virtualPath == null)
				throw new ArgumentNullException ("virtualPath");
#else
			if (virtualPath == null)
				throw new HttpException ("virtualPath is null");
#endif
			Type type = GetTypeFromControlPath (virtualPath);
			object [] attrs = type.GetCustomAttributes (typeof (PartialCachingAttribute), true);
			if (attrs != null && attrs.Length == 1) {
				PartialCachingAttribute attr = (PartialCachingAttribute) attrs [0];
				PartialCachingControl ctrl = new PartialCachingControl (type);
				ctrl.VaryByParams = attr.VaryByParams;
				ctrl.VaryByControls = attr.VaryByControls;
				ctrl.VaryByCustom = attr.VaryByCustom;
				return ctrl;
			}

			object control = Activator.CreateInstance (type);
			if (control is UserControl)
				((UserControl) control).InitializeAsUserControl (Page);

			return (Control) control;
		}

		public ITemplate LoadTemplate (string virtualPath)
		{
#if NET_2_0
			if (virtualPath == null)
				throw new ArgumentNullException ("virtualPath");
#else
			if (virtualPath == null)
				throw new HttpException ("virtualPath is null");
#endif
			Type t = GetTypeFromControlPath (virtualPath);
			return new SimpleTemplate (t);
		}

		protected virtual void OnAbortTransaction (EventArgs e)
		{
			EventHandler eh = Events [abortTransaction] as EventHandler;
			if (eh != null)
				eh (this, e);
		}

		protected virtual void OnCommitTransaction (EventArgs e)
		{
			EventHandler eh = Events [commitTransaction] as EventHandler;
			if (eh != null)
				eh (this, e);
		}

		protected virtual void OnError (EventArgs e)
		{
			EventHandler eh = Events [error] as EventHandler;
			if (eh != null)
				eh (this, e);
		}

		[MonoTODO ("Not implemented, always returns null")]
		public Control ParseControl (string content)
		{
			if (content == null)
				throw new ArgumentNullException ("content");

			return null;
		}

		[EditorBrowsable (EditorBrowsableState.Never)]
		public 
#if !NET_2_0
		static
#endif
		object ReadStringResource ()
		{
			throw new NotSupportedException ();
		}

#if NET_2_0
		protected object GetGlobalResourceObject (string className, string resourceKey)
		{
			return HttpContext.GetGlobalResourceObject (className, resourceKey);
		}

		[MonoTODO ("Not implemented")]
		protected object GetGlobalResourceObject (string className, string resourceKey, Type objType, string propName)
		{
			// FIXME: not sure how to implement that one yet
			throw new NotSupportedException();
		}

		protected object GetLocalResourceObject (string resourceKey)
		{
			return HttpContext.GetLocalResourceObject (Context.Request.CurrentExecutionFilePath, resourceKey);
		}
		
		protected object GetLocalResourceObject (string resourceKey, Type objType, string propName)
		{
			// FIXME: not sure how to implement that one yet
			throw new NotSupportedException();
		}
#endif
		
		[EditorBrowsable (EditorBrowsableState.Never)]
		public static object ReadStringResource (Type t)
		{
			throw new NotSupportedException ();
		}

		[MonoTODO ("Not implemented, does nothing")]
		[EditorBrowsable (EditorBrowsableState.Never)]
		protected void SetStringResourcePointer (object stringResourcePointer,
							 int maxResourceOffset)
		{
		}

		[MonoTODO ("Not implemented, does nothing")]
		[EditorBrowsable (EditorBrowsableState.Never)]
		protected void WriteUTF8ResourceString (HtmlTextWriter output, int offset,
							int size, bool fAsciiOnly)
		{
		}

		#endregion

		#region Events

		[WebSysDescription ("Raised when the user aborts a transaction.")]
		public event EventHandler AbortTransaction {
			add { Events.AddHandler (abortTransaction, value); }
			remove { Events.RemoveHandler (abortTransaction, value); }
		}

		[WebSysDescription ("Raised when the user initiates a transaction.")]
		public event EventHandler CommitTransaction {
			add { Events.AddHandler (commitTransaction, value); }
			remove { Events.RemoveHandler (commitTransaction, value); }
		}

		[WebSysDescription ("Raised when an exception occurs that cannot be handled.")]
		public event EventHandler Error {
			add { Events.AddHandler (error, value); }
			remove { Events.RemoveHandler (error, value); }
		}

		#endregion

		class SimpleTemplate : ITemplate
		{
			Type type;

			public SimpleTemplate (Type type)
			{
				this.type = type;
			}

			public void InstantiateIn (Control control)
			{
				Control template = Activator.CreateInstance (type) as Control;
				template.SetBindingContainer (false);
				control.Controls.Add (template);
			}
		}

#if NET_2_0
		protected object Eval (string expression)
		{
			return DataBinder.Eval (Page.GetDataItem(), expression);
		}
	
		protected string Eval (string expression, string format)
		{
			return DataBinder.Eval (Page.GetDataItem(), expression, format);
		}
	
		protected object XPath (string xpathexpression)
		{
			return XPathBinder.Eval (Page.GetDataItem(), xpathexpression);
		}
	
		protected string XPath (string xpathexpression, string format)
		{
			return XPathBinder.Eval (Page.GetDataItem(), xpathexpression, format);
		}
	
		protected IEnumerable XPathSelect (string xpathexpression)
		{
			return XPathBinder.Select (Page.GetDataItem(), xpathexpression);
		}

		// IFilterResolutionService

		[MonoTODO ("Not implemented")]
		int IFilterResolutionService.CompareFilters (string filter1, string filter2)
		{
			throw new NotImplementedException ();
		}

		[MonoTODO ("Not implemented")]
		bool IFilterResolutionService.EvaluateFilter (string filterName)
		{
			throw new NotImplementedException ();
		}
#endif
	}
}
