/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.10 2001/12/25 13:59:36 ostborn Exp $
*/

#include <libintl.h>
#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>

#include "mconfig.h"
#include "mstate.h"
#include "mlocale.h"
#include "mhash.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mplugins.h"

#include "pictures.h"
#include "plugin_config.h"

int mplugins_output_webalizer_dlinit(mconfig *ext_conf) {
	config_output *conf = NULL;
	
	conf = malloc(sizeof(config_output));
	
	memset(conf, 0, sizeof(config_output));
	
	ext_conf->plugin_conf = conf;
	
	return 0;
}

int mplugins_output_webalizer_dlclose(mconfig *ext_conf) {
	config_output *conf = ext_conf->plugin_conf;
	
	if (conf->col_hosts)	free(conf->col_hosts);
	if (conf->col_visits)	free(conf->col_visits);
	if (conf->col_hits)	free(conf->col_hits);
	if (conf->col_files)	free(conf->col_files);
	if (conf->col_backgnd)	free(conf->col_backgnd);
	if (conf->col_shadow)	free(conf->col_shadow);
	if (conf->col_pages)	free(conf->col_pages);
	if (conf->col_xfer)	free(conf->col_xfer);
	if (conf->col_grouping)	free(conf->col_grouping);
	if (conf->col_body)	free(conf->col_body);

	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;
	
	return 0;
}

int mplugins_output_webalizer_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	config_output *conf = ext_conf->plugin_conf;
	
	const mconfig_values config_values[] = {
	/* color tripples */
		{"background",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_backgnd)},
		{"shadow",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_shadow)},
		{"pages",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_pages)},
		{"files",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_files)},
		{"visits",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_visits)},
		{"xfer",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_xfer)},
		{"hosts",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_hosts)},
		{"hits",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_hits)},
		{"grouping",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_grouping)},
		{"body",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_body)},
	/* integer */
		{"maxrequrls",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_req_urls)},
		{"maxos",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_os)},
		{"maxhosts",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_hosts)},
		{"maxrefurls",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_ref_urls)},
		{"maxentrypages", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_entry_pages)},
		{"maxexitpages", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_exit_pages)},
		{"maxindexedpages", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_indexed_pages)},
		{"maxua",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_ua)},
		{"maxreqprot",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_req_prot)},
		{"maxreqmeth",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_req_meth)},
		{"maxstatuscodes", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_status_codes)},
		{"maxbookmarks", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_bookmarks)},
		{"maxbrokenlinks", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_broken_links)},
		{"maxsearchengines", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_search_engines)},
		{"maxsearchstrings", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_search_strings)},
		{"maxinteralerrors", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_internal_errors)},
		{"maxcountries", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_countries)},
		{"maxrobots", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_robots)},
	/* strings */	
		{"hostname", M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->hostname)},
		
		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};
	
	return mconfig_parse_section(ext_conf, filename, section, config_values);
}

int mplugins_output_webalizer_set_defaults(mconfig *ext_conf) {
	config_output *conf = ext_conf->plugin_conf;
#define LOCALHOST	"localhost"
	
	if (conf->hostname == NULL) {
		conf->hostname = malloc(strlen(LOCALHOST)+1);
		strcpy(conf->hostname, LOCALHOST);
	}
		
	return 0;
}

int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_output_webalizer_dlinit;
	func->dlclose = mplugins_output_webalizer_dlclose;
	func->parse_config = mplugins_output_webalizer_parse_config;
	func->set_defaults = mplugins_output_webalizer_set_defaults;
	func->get_next_record = NULL;
	func->insert_record = NULL;
	func->gen_report = mplugins_output_webalizer_generate_monthly_output;
        func->gen_history = mplugins_output_webalizer_generate_history_output;
	
	return 0;
}
