/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: generate.c,v 1.2 2001/03/25 19:19:49 jk Exp $
*/

#include <libintl.h>
#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>


#include "mconfig.h"
#include "mstate.h"
#include "mlocale.h"
#include "mhash.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mplugins.h"

#include "plugin_config.h"

int mplugins_output_generate_monthly_output(mconfig *ext_conf, mstate *state, const char *subpath) {
	FILE *f = NULL;
	char filename[255];
	config_output *conf = ext_conf->output;
	
	if (!state->ext) return -1;
	
	if (state->ext_type != M_STATE_TYPE_WEB) return -1;
	
	if (subpath) {
		sprintf(filename, "%s/%s/",
			ext_conf->outputdir ? ext_conf->outputdir : ".",
			subpath);
		mkdir(filename, 0755);
	}
	
	if (f) {
		file_end(f,ext_conf);
	
		fclose (f);
	}
	
	return 0;
}

int mplugins_output_generate_history_output(mconfig *ext_conf, mlist *history, const char *subpath) {
	FILE *f;
	char filename[255];
	config_output *conf = ext_conf->output;
	
	sprintf(filename, "%s%s%s/index.html", 
		ext_conf->outputdir ? ext_conf->outputdir : ".",
		subpath ? "/" : "",
		subpath ? subpath : "" );
	
	if (!(f = fopen(filename, "w"))) {
		return -1;
	}
	
	fclose(f);
	
	return 0;
}
