/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: parse.c,v 1.3 2001/06/04 19:14:50 jk Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

#define DEBUG_PCRE

int parse_record_pcre(mconfig *ext_conf, mlogrec *record, char *_buffer) {
#define N 20 + 1
	const char **list;
	int ovector[3 * N], n;
#ifdef DEBUG_PCRE
	int i;
#endif

	config_input *conf = ext_conf->plugin_conf;
	mlogrec_web *recweb = NULL; 
	mlogrec_web_squid *recsqd = NULL; 

	record->ext_type = M_RECORD_TYPE_WEB;
	record->ext = mrecord_init_web();
	
	recweb = record->ext;
	
	if (recweb == NULL) return -1;
	
	recweb->ext = mrecord_init_web_squid();
	recweb->ext_type = M_RECORD_TYPE_WEB_SQUID;
	
	recsqd = recweb->ext;
	
	if (recsqd == NULL) return -1;

	if ((n = pcre_exec(conf->match_skeleton, conf->match_skeleton_extra, _buffer, strlen(_buffer), 0, 0, ovector, 3 * N)) < 0) {
		if (n == PCRE_ERROR_NOMATCH) {
			fprintf(stderr, "%s.%d: string doesn't match: %s\n", __FILE__, __LINE__, _buffer);
		} else {
			fprintf(stderr, "%s.%d: execution error while matching: %d\n", __FILE__, __LINE__, n);
		}
		return -1;
	}

	if (n) {
		pcre_get_substring_list(_buffer, ovector, n, &list);
		
/* the meaning of the different fields (squid) */
	/* 
	   1 - timestamp in sec
	   2 - +timestamp in msec
	   3 - duration in msec
	   4 - client-ip
	   5,6 - status
	   7 - xfersize
	   8 - request method (GET, ...)
	   9 - requested url
	   10 - authentication-user-id (RFC931)
	   11 - hierachary code
	   12 - ... sub cody
	   13 - type
	*/

	/*
		record->timestamp = strtol(list[1], NULL, 10);
		
		recweb->req_host = malloc(strlen((char *)list[4])+1);
		strcpy(recweb->req_host, (char *)list[4]);
		
		recweb->req_status = strtol(list[6], NULL,10);
	
		recweb->xfersize = strtol(list[7], NULL,10);
		
		recweb->req_method = malloc(strlen((char *)list[8])+1);
		strcpy(recweb->req_method, (char *)list[8]);
	
		recweb->req_url = malloc(strlen((char *)list[9])+1);
		strcpy(recweb->req_url, (char *)list[9]);
	 */

		for (i = 0; i < n; i++) {
			printf("%d: %s\n", i, list[i]);
		}

		free(list);
	}

	return 0;
#undef  N
}


int mplugins_input_skeleton_get_next_record(mconfig *ext_conf, mlogrec *record) {
	int ret = 0;
	config_input *conf = ext_conf->plugin_conf;
	
	if (!fgets(conf->buffer, conf->buf_len-1,conf->inputfile)) {
		return M_RECORD_EOF;
	}

	while (conf->buffer[strlen(conf->buffer)-1] != '\n') {
		conf->buffer = realloc(conf->buffer, (conf->buf_len+conf->buf_inc) * sizeof(char));
		
		if (!fgets(conf->buffer+strlen(conf->buffer), conf->buf_inc-1,conf->inputfile)) {
			return M_RECORD_EOF;
		}
		
		conf->buf_len += conf->buf_inc;
	}
	ret = parse_record_pcre(ext_conf, record, conf->buffer);

/* the Skeleton itself should do nothing although it compiles fine 
 * that's why we return M_RECORD_EOF here
 */
#if 0
	return ret == -1 ? M_RECORD_CORRUPT : M_RECORD_NO_ERROR;
#else
	return M_RECORD_EOF;
#endif
}
