/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.3 2001/10/22 21:12:50 ostborn Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

/* this code is taken from the squid plugin */

/* init the plugin */

int mplugins_input_sendmail_dlinit(mconfig *ext_conf) {
	config_input *conf = NULL;
	const char *errptr;
	int erroffset = 0;

/* get the neccesary space */
	conf = malloc(sizeof(config_input));
	memset(conf, 0, sizeof(config_input));

/* set some defaults */	
	conf->inputfilename = NULL;
	
	conf->inputfile = stdin;
	
	conf->buf_len = 256;
	conf->buf_inc = 128;
	conf->buffer = malloc(conf->buf_len * sizeof(char));

/* compile the match */	
	if ((conf->match_syslog = 
	     /*            timestamp                         ... magic      pid          queue-id      */
	     pcre_compile("([a-zA-Z]{3} [0-9 ]{2} [:0-9]{8}) .+? sendmail\\[[0-9]+\\]: ([0-9a-zA-Z]+):",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	} 
	
	if ((conf->match_sendmail_from = 
	     pcre_compile("from=(.+?), size=([0-9]+),.*nrcpts=([0-9]+)",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	} 
	
	if ((conf->match_sendmail_to = 
	     pcre_compile("to=(.+?), .*dsn=(.+), stat=((Sent) \\((.+?)\\)|(Deferred): (.+)|(Service unavailable)|(queued))",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_sendmail_warning = 
	     pcre_compile("([0-9a-zA-Z]{12}): (.*)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_sendmail_noqueue = 
	     pcre_compile("NOQUEUE: (.+)$",
			  0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
	if ((conf->match_timestamp = pcre_compile(
		"^([a-zA-Z]{3}) +([0-9]{1,2}) ([0-9]{2}):([0-9]{2}):([0-9]{2})", 
		0, &errptr, &erroffset, NULL)) == NULL) {
		
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}
	
/* connect the plugin config to the master config */	
	ext_conf->plugin_conf = conf;
	
	return 0;
}

/* destructor */

int mplugins_input_sendmail_dlclose(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;

/* clean up everything you have opened, reserved */
	if (conf->inputfilename && strcmp(conf->inputfilename, "-")) {
		fclose(conf->inputfile);
	}
	
	free(conf->match_sendmail_to);
	free(conf->match_sendmail_from);
	free(conf->match_syslog);
	
	free(conf->buffer);
	
	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;
	
	return 0;
}

int mplugins_input_sendmail_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	config_input *conf = ext_conf->plugin_conf;
	
/* add your config options here. the format of the struct: 
 * {"<name of the option>", <type>, <how to handle the further 
 * occurences of the same value>, <address of the pointer where 
 * the value should go to> }
 *
 * you only have the change config_values[] the rest is done in the
 * background (-> ./src/mconfig.c)
 */
	const mconfig_values config_values[] = {
		{"inputfile",	M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->inputfilename)},
		
/* terminate the array of options */		
		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};
	
	return mconfig_parse_section(ext_conf, filename, section, config_values);
}


int mplugins_input_sendmail_set_defaults(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;

/* set some usefull defaults and do the stuff that has to be done at the
 * END of the config-process. this function is called when all configfiles
 * are successfully parsed. it's good place to open files here or the
 * compile regex on the fly (-> ./src/input/clf using the format-key)
 */
	
	if (conf->inputfilename && strcmp(conf->inputfilename, "-")) {
		if (!(conf->inputfile = fopen(conf->inputfilename, "r"))) {
			fprintf(stderr, "%s %s: %s\n", _("Can't open inputfile "), conf->inputfilename, strerror(errno));
			return -1;
		}
	}
	
	return 0;
}


int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_input_sendmail_dlinit;
	func->dlclose = mplugins_input_sendmail_dlclose;
	func->parse_config = mplugins_input_sendmail_parse_config;
	func->set_defaults = mplugins_input_sendmail_set_defaults;
	func->get_next_record = mplugins_input_sendmail_get_next_record;
	func->insert_record = NULL;
	func->gen_report = NULL;
        func->gen_history = NULL;
	 
	return 0;
}
