/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: parse.c,v 1.2 2001/11/12 10:00:39 ostborn Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

int parse_record_pcre(mconfig *ext_conf, mlogrec *record, char *_buffer) {
#define N 20 + 1
	const char **list;
	int ovector[3 * N], n;

	config_input *conf = ext_conf->plugin_conf;
	mlogrec_web *recweb = NULL; 
	mlogrec_web_ftp *recftp = NULL; 

	record->ext_type = M_RECORD_TYPE_WEB;
	record->ext = mrecord_init_web();
	
	recweb = record->ext;
	
	if (recweb == NULL) return M_RECORD_HARD_ERROR;
	
	recweb->ext = mrecord_init_web_ftp();
	recweb->ext_type = M_RECORD_TYPE_WEB_FTP;
	
	recftp = recweb->ext;
	
	if (recftp == NULL) return M_RECORD_HARD_ERROR;

	if ((n = pcre_exec(conf->match_pureftpd, conf->match_pureftpd_extra, _buffer, strlen(_buffer), 0, 0, ovector, 3 * N)) < 0) {
		if (n == PCRE_ERROR_NOMATCH) {
			fprintf(stderr, "%s.%d: string doesn't match: %s\n", __FILE__, __LINE__, _buffer);
			return M_RECORD_CORRUPT;
		} else {
			fprintf(stderr, "%s.%d: execution error while matching: %d\n", __FILE__, __LINE__, n);
			return M_RECORD_HARD_ERROR;
		}
	}

	if (n) {
		pcre_get_substring_list(_buffer, ovector, n, &list);
		
		/* the meaning of the different fields (pureftpd) */
		
		/* 
		 * 1 - timestamp in sec
		 * 2 - session id
		 * 3 - username
		 * 4 - client-ip
		 * 5 - up/download
		 * 6 - size
		 * 7 - duration
		 * 8 - filename
		 */

		record->timestamp = strtol(list[1], NULL, 10);
		
		recweb->req_user = malloc(strlen((char *)list[3])+1);
		strcpy(recweb->req_user, (char *)list[3]);
		
		recweb->req_host = malloc(strlen((char *)list[4])+1);
		strcpy(recweb->req_host, (char *)list[4]);
		
		switch(*list[5]) {
		case 'D':
			recftp->trans_command = M_RECORD_FTP_COMMAND_GET;
			break;
		case 'U':
			recftp->trans_command = M_RECORD_FTP_COMMAND_PUT;
			break;
		default:
			break;
		}
		
		recweb->xfersize = strtol(list[6], NULL,10);
		
		recftp->trans_duration = strtol(list[7], NULL,10);
		
		recweb->req_url = malloc(strlen((char *)list[8])+1);
		strcpy(recweb->req_url, (char *)list[8]);

		free(list);
	}

	return M_RECORD_NO_ERROR;
}


int mplugins_input_pureftpd_get_next_record(mconfig *ext_conf, mlogrec *record) {
	config_input *conf = ext_conf->plugin_conf;
	
	if (!fgets(conf->buffer, conf->buf_len-1,conf->inputfile)) {
		return M_RECORD_EOF;
	}

	while (conf->buffer[strlen(conf->buffer)-1] != '\n') {
		conf->buffer = realloc(conf->buffer, (conf->buf_len+conf->buf_inc) * sizeof(char));
		
		if (!fgets(conf->buffer+strlen(conf->buffer), conf->buf_inc-1,conf->inputfile)) {
			return M_RECORD_EOF;
		}
		
		conf->buf_len += conf->buf_inc;
	}
	
	return parse_record_pcre(ext_conf, record, conf->buffer);
}
