/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.6 2001/10/06 16:32:17 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>


#include <zlib.h>
#include <libxml/tree.h>

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"

/* begin of Traffic */

int mdata_Traffic_to_xml(gzFile *fd, mdata *data) {
	return 0;
}

int mdata_Traffic_free(mdata *data) {
	if (!data) return -1;
	if (data->type != M_DATA_TYPE_TRAFFIC) return -1;
	
	if (data->data.traffic.src) free(data->data.traffic.src);
	if (data->data.traffic.dst) free(data->data.traffic.dst);
	
	return 0;
}

int mdata_Traffic_setdata(mdata *data, const char *str, 
			  const char *src,
			  const char *dst,
			  unsigned long long xfer_in, 
			  unsigned long long xfer_out,
			  int src_port,
			  int dst_port,
			  int src_as,
			  int dst_as) {
	
	data->key	= malloc(strlen(str)+1);
	assert(data->key);
	strcpy(data->key, str);
	
	data->data.traffic.src	= malloc(strlen(src)+1);
	assert(data->data.traffic.src);
	strcpy(data->data.traffic.src, src);
	
	data->data.traffic.dst	= malloc(strlen(dst)+1);
	assert(data->data.traffic.dst);
	strcpy(data->data.traffic.dst, dst);
	
	data->data.traffic.xfer_in	= xfer_in;
	data->data.traffic.xfer_out	= xfer_out;
	
	/* HACK */
	data->data.traffic.src_port	= src_port;
	data->data.traffic.dst_port	= dst_port;
	
	data->data.traffic.src_as	= src_as;
	data->data.traffic.dst_as	= dst_as;
	return 0;
}
int mdata_Traffic_from_xml(mstate_stack *m, int tagtype, mdata *data, int type, const xmlChar *value, const xmlChar **attrs) {
	return 0;
}



int mdata_Traffic_append(mdata *dst, mdata *src) {
	dst->data.traffic.xfer_in += src->data.traffic.xfer_in;
	dst->data.traffic.xfer_out += src->data.traffic.xfer_out;
	
	return M_DATA_APPENDED;
}

mdata *mdata_Traffic_init() {
	mdata *data = mdata_init();
	assert(data);
	
	data->key		= NULL;
	data->type		= M_DATA_TYPE_TRAFFIC;
	
#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
/* init specifics */	

	data->data.traffic.src  = NULL;
	data->data.traffic.dst  = NULL;
	data->data.traffic.xfer_in = 0;
	data->data.traffic.xfer_out = 0;

	return data;
}

mdata *mdata_Traffic_copy(mdata *src) {
	mdata *data = mdata_Traffic_init();
	assert(data);
	
	mdata_Traffic_setdata(data, src->key, 
			      src->data.traffic.src,
			      src->data.traffic.dst,
			      src->data.traffic.xfer_in, 
			      src->data.traffic.xfer_out,
			      src->data.traffic.src_port,
			      src->data.traffic.dst_port,
			      src->data.traffic.src_as,
			      src->data.traffic.dst_as);

	return data;
}

mdata  *mdata_Traffic_create(
			     const char *src, 
			     const char *dst, 
			     unsigned long long xfer_in,
			     unsigned long long xfer_out,
			     int src_port,
			     int dst_port,
			     int src_as,
			     int dst_as
	) {
	
	char *s = NULL;
		
	mdata *data = mdata_Traffic_init();
	assert(data);
	
	s = malloc(strlen(src) + strlen(dst) + 2);
	sprintf(s, "%s|%s", src, dst);
	
	mdata_Traffic_setdata(data, s, src, dst, xfer_in, xfer_out, src_port, dst_port, src_as, dst_as);
	
	free(s);
	
	return data;
}

/* end of Traffic */
