# Artist: the electric prunes
# Song: I had too much to dream (last night)
# Composers: Annette Tucker / Nancy Mantz

# based on too_much_to_dream.crd transcribed by Andrew Rogers

@head {
	$tempo 140 $time_sig 4/4
}

@body {

	# bass

	%define bass_1 {
		/l8/c3 g3 c3 g3 c3 g3 c3 g3
	}

	@channel 1 "bass" {
		$patch 36 $volume 127

		# intro
		%repeat 2 { ~bass_1/2/ }

		%repeat 2 {

			# verse
			%repeat 2 {
				%repeat 2 { ~bass_1/2/ }
				%repeat 2 { ~bass_1 }
			}
			%repeat 2 { ~bass_1/7/ }
			%repeat 2 { ~bass_1/2/ }
			%repeat 2 { ~bass_1/7/ }
			~bass_1/2/ /l1/g3
			
			r # rest for drum count in
			
			%repeat 2 { ~bass_1/2/ }
			%repeat 2 { ~bass_1/1/ }
			/l3:8/g3 f e- /l4r5/r

			# chorus

			%repeat 3 { ~bass_1/2/ ~bass_1/7/ }
			~bass_1/2/ /l1/a3
			%repeat 2 { /l2/d3 c b-2 c3 }

		}
		# repeat chorus to end
		%repeat 3 { ~bass_1/2/ ~bass_1/7/ }
		~bass_1/2/ /l1/a3
		%repeat 6 { /l2/d3 c b-2 c3 }
	}

	# guitar chords

	%define Dm {
		( d3 f3 a3 d4 f4 a4 )
	}

	%define C {
		( c3 e3 g3 c4 e4 g4 )
	}

	%define Gm {
		( g3 b-3 d4 g4 b-4 d3 )
	}

	%define G {
		( g3 b3 d4 g4 b4 d3 )
	}

	%define F {
		( f3 a3 c4 f4 a4 c3 )
	}

	%define E- {
		( e-3 g3 b-3 e-4 g4 b-4 )
	}

	%define C+m {
		( c+3 e3 g+3 c+4 e4 g+4 )
	}

	%define A {
		( a2 e3 a3 c+4 e4 )
	}

	%define B- {
		( b-2 f3 b-3 d4 f4 )
	}

	@channel 2 "guitar" {
		$patch 27 $volume 32

		/l1r2/r # rest for intro

		%repeat 2 {

			# verse
			%repeat 2 {
				%repeat 2 { ~Dm }
				%repeat 2 { ~C }
			}
			%repeat 2 { ~Gm }
			%repeat 2 { ~Dm }
			%repeat 2 { ~Gm }
			~Dm ~G

			r # rest for drum count in

			# bridge
			%repeat 2 { ~Dm }
			%repeat 2 { ~C+m }
			$length 3:8
			~G ~F $length 2 ~E- /l8r9/r

			# chorus
			$length 1
			%repeat 3 { ~Dm ~G }
			~Dm ~A
			$length 2
			%repeat 2 { ~Dm ~C ~B- ~C }
		}
		# repeat chorus to end
		$length 1
		%repeat 3 { ~Dm ~G }
		~Dm ~A
		$length 2
		%repeat 6 { ~Dm ~C ~B- ~C }
	}

	# drums

	%define drums_1 { /l8r2/c3 d c }

	@channel 10 "drums" {
		$volume 127 $reverb 32

		/l1r18/r # rest for first verse

		/l4r2/d3 /l8/d c d c # count in

		# bridge
		%repeat 8 { ~drums_1 }
		/l3:8r3/d3 /l4/r /r2/d3 /l8/d c d c

		# chorus
		%repeat 16 { ~drums_1 }
		%repeat 8 { /l4/d3 c }

		# 2nd time round
		# verse
		%repeat 30 { ~drums_1 }
		/l1/r

		/l4r2/d3 /l8/d c d c # count in

		# bridge
		%repeat 8 { ~drums_1 }
		/l3:8r3/d3 /l4/r /r2/d3 /l8/d c d c

		# chorus
		%repeat 16 { ~drums_1 }
		%repeat 8 { /l4/d3 c }

		# repeat chorus to end
		%repeat 16 { ~drums_1 }
		%repeat 24 { /l4/d3 c }
	}

	# cymbals

	%define cymbals_1 {
		/l8r2/f+3 g+ f+ /r2/f+ g+ f+
	}

	@channel 10 "cymbals" {
		$volume 48

		/l1r2/r # rest for intro

		%repeat 2 {

			%repeat 15 { /l8r8/f+3 }
			/l1/c+4

			/l4r2/c+4 /r2/f+3 # drum count in

			# bridge
			%repeat 4 { /l8r8/f+3 }
			/l3:8r3/c+4 /l4/r /r2/c+4 /r2/f+3

			# chorus
			%repeat 3 { /l4/r f+3 r f+3 r f+3 r c+4 }
			/l4/r f+3 r c+4
			/l1/r /l2r8/c+4
		}
		# repeat chorus to end
		%repeat 3 { /l4/r f+3 r f+3 r f+3 r c+4 }
		/l4/r f+3 r c+4
		/l1/r /l2r24/c+4
	}
}
