/*
 * Copyright (C) 2001,2002 Red Hat, Inc.
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Modified by muntyan so it works on BSD too */
/* mooterm/pty.h */

#ifndef MOOTERM_VTE_PTY_H
#define MOOTERM_VTE_PTY_H

#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif


#define _vte_pty_open		_moo_vte_pty_open
#define _vte_pty_get_size	_moo_vte_pty_get_size
#define _vte_pty_set_size	_moo_vte_pty_set_size
#define _vte_pty_set_echo_input	_moo_vte_pty_set_echo_input
#define _vte_pty_close		_moo_vte_pty_close
#define _vte_pty_n_read		_moo_vte_pty_n_read
#define _vte_pty_n_write	_moo_vte_pty_n_write
#define _vte_pty_open_pt	_moo_vte_pty_open_pt


/* Start up the given binary (exact path, not interpreted at all) in a
 * pseudo-terminal of its own, returning the descriptor for the master
 * side of the PTY pair, logging the session to the specified files, and
 * storing the child's PID in the given argument. */
int _vte_pty_open(pid_t *child, char **env_add,
		  const char *command, char **argv, const char *directory,
		  int columns, int rows,
		  int lastlog, int utmp, int wtmp);

int _vte_pty_open_pt(char **name);

/* Set or read the size of a terminal.  Returns 0 on success, -1 on failure,
 * with errno set to defined return codes from ioctl(). */
int _vte_pty_get_size(int master, int *columns, int *rows);
int _vte_pty_set_size(int master, int columns, int rows);
int _vte_pty_set_echo_input(int master, int echo);

/* Close a pty. */
void _vte_pty_close(int pty);

/* Like read, but hide EINTR and EAGAIN. */
ssize_t _vte_pty_n_read (int fd, void *buffer, size_t count);

/* Like write, but hide EINTR and EAGAIN. */
ssize_t _vte_pty_n_write (int fd, const void *buffer, size_t count);


#ifdef __cplusplus
}
#endif

#endif /* MOOTERM_VTE_PTY_H */
