""" The absolute filenames of the plugin definitions used in the application.

The only reason that we put this in a separate module is that it often entails
lots of path and filename manipulation code that tends to clutter up 'run.py'.

The important thing to realise is that all we are doing is defining a list of
strings which are the absolute filenames of the plugin definition used in the
application!

"""

from os.path import abspath, dirname, join

# Enthought library imports.
from enthought.envisage.api import find_definition

envisage_examples_dir = dirname(dirname(dirname(abspath(__file__))))

# The plugin definitions required by the application.
PLUGIN_DEFINITIONS = [
    # Envisage plugins.
    find_definition('enthought.envisage.core.core_plugin_definition'),
    find_definition('enthought.envisage.ui.ui_plugin_definition'),
    find_definition('enthought.envisage.ui.preference.preference_plugin_definition'),
    find_definition('enthought.envisage.ui.python_shell.python_shell_plugin_definition'),
    
    # Application plugins.
    join(envisage_examples_dir, 'plugin','simple_ui','plugin_definition.py'),
]

# The plugin definitions that we want to import from but don't want as part of
# the application.
INCLUDE = []

#### EOF ######################################################################
