""" The absolute filenames of the plugin definitions used in the application.

The only reason that we put this in a separate module is that it often entails
lots of path and filename manipulation code that tends to clutter up 'run.py'.

The important thing to realise is that all we are doing is defining a list of
strings which are the absolute filenames of the plugin definition used in the
application!

"""

from os.path import dirname, abspath, join

# Enthought library imports.
from enthought.envisage.api import find_definition

envisage_examples_dir = dirname(dirname(dirname(abspath(__file__))))

# The plugin definitions used in the application.
PLUGIN_DEFINITIONS = [
    # Envisage plugins.
    find_definition('enthought.envisage.core.core_plugin_definition'),
    find_definition('enthought.envisage.resource.resource_plugin_definition'),
    find_definition('enthought.envisage.workbench.workbench_plugin_definition'),
    find_definition('enthought.envisage.action.action_plugin_definition'),
    find_definition('enthought.envisage.workbench.action.action_plugin_definition'),

    # Enthought plugins.
    find_definition('enthought.plugins.python_shell.python_shell_plugin_definition'),
    find_definition('enthought.plugins.text_editor.text_editor_plugin_definition'),

    # Application plugins.
    join(envisage_examples_dir, 'plugin','acme','plugin_definition.py')
]

#### EOF ######################################################################
