""" The UI for the Envisage workbench. """


# Enthought library imports.
from enthought.io.api import File
from enthought.pyface.api import FileDialog, OK
from enthought.traits.api import HasTraits, Instance

# Local imports.
from workbench import Workbench


class WorkbenchUI(HasTraits):
    """ The UI for the Envisage workbench. """

    ### 'WorkbenchUI' interface ##############################################

    # The corresponding workbench.
    workbench = Instance(Workbench)

    ##########################################################################
    # 'WorkbenchUI' interface.
    ##########################################################################

    def about(self, event):
        """ Displays the 'About' dialog. """

        # We put the import here 'cos there's no need to do it until it is
        # actually required!
        from enthought.pyface.api import AboutDialog

        dialog = AboutDialog(
            parent = event.window.control,
            image  = self.workbench.branding.about_image,
            additions = self.workbench.branding.about_additions,
        )
        dialog.open()

        return

    def exit(self, event):
        """ Exits the workbench. """

        self.workbench.exit()

        return

    # fixme: These actions should be implemented in the text editor plugin!
    def new_file(self, event):
        """ Creates a new file. """

        self.workbench.edit(File(''), use_existing=False)

        return

    def open_file(self, event):
        """ Opens a file. """

        dialog = FileDialog(parent=event.window.control, title='Open File')
        if dialog.open() == OK:
            self.workbench.edit(File(dialog.path))

        return

### EOF ######################################################################
