""" Base class for all actions that listen to the window selection. """


# Local imports.
from workbench_action import WorkbenchAction


class SelectionListenerAction(WorkbenchAction):
    """ Base class for all actions that listen to the window selection. """

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def destroy(self):
        """ Called when the action is no longer required. """

        if self.window is not None:
            self.window.on_trait_change(
                self._on_selection_changed, 'selection', remove=True
            )
            
        return

    ###########################################################################
    # 'SelectionListenerAction' interface.
    ###########################################################################

    def refresh(self):
        """ Refresh the enabled/disabled state of the action etc.

        This is called whenever the workbench window that the action is in
        and/or the selection in that window have been changed.

        """

        raise NotImplementedError
    
    ###########################################################################
    # Private interface.
    ###########################################################################

    #### Trait event handlers #################################################

    #### Static ####
    
    def _window_changed(self, old, new):
        """ Called when the action's window is changed. """

        if old is not None:
            old.on_trait_change(
                self._on_selection_changed, 'selection', remove=True
            )

        if new is not None:
            new.on_trait_change(self._on_selection_changed, 'selection')

        self.refresh()
            
        return

    #### Dynamic ####
    
    def _on_selection_changed(self, obj, trait_name, old, new):
        """ Called when the selection is changed in the action's window. """

        self.refresh()

        return

#### EOF ######################################################################
