""" Displays the preferences dialog. """


# Enthought library imports.
from enthought.envisage.ui import WorkbenchAction
from enthought.pyface.preference.api import PreferenceDialog
from enthought.envisage.ui.preference import PreferencePlugin


class EditPreferencesAction(WorkbenchAction):
    """ Displays the preferences dialog. """

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self):
        """ Performs the action. """

        plugin = PreferencePlugin.instance

        dialog = PreferenceDialog(
            parent = self.window.control,
            title  = 'Preferences',
            root   = plugin.root,
            style  = 'nonmodal',
            size   = (600, 400)
        )
        dialog.open()

        return

#### EOF ######################################################################
