""" Display the 'About' dialog. """


# Enthought library imports.
from enthought.envisage.ui import UIPlugin, WorkbenchAction
from enthought.pyface.api import AboutDialog


class AboutAction(WorkbenchAction):
    """ Display the 'About' dialog. """
        
    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self):
        """ Performs the action. """                

        dialog = AboutDialog(
            parent = self.window.control,
            image  = UIPlugin.instance.about_image,
            additions = UIPlugin.instance.library_versions
        )
        dialog.open()

        return

#### EOF ######################################################################
