""" A script recorder. """


# Enthought library imports.
from enthought.traits.api import Bool, HasTraits, Instance

# Local imports.
from scripting import ScriptingNamespace


class ScriptRecorder(HasTraits):
    """ A script recorder. """

    #### 'ScriptRecorder' interface ###########################################

    # Are we recording?
    recording = Bool(False)
    
    # The scripting API that we record.
    scripting = Instance(ScriptingNamespace)

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _pre_hook(self, name, callable, *args, **kw):
        """ A hook into the scripting API to do macro recording. """

        # Format the call.
        s = name + '('
        s = s + ','.join([repr(arg) for arg in args])
        
        kw_args = []
        for name, value in kw.items():
            kw_args.append(name + '=' + repr(value))

        s = s + ','.join(kw_args) + ')\n'
        
        print '**** MACRO:', s
        
        return

    #### Trait change handlers ################################################
    
    def _recording_changed(self, old, new):
        """ Static trait change handler. """

        if self.recording:
            if self.scripting is not None:
                self.scripting.add_pre_hook(self._pre_hook)

        else:
            if self.scripting is not None:
                self.scripting.remove_pre_hook(self._pre_hook)
            
        return

    def _scripting_changed(self, old, new):
        """ Static trait change handler. """

        if old is not None and self.recording:
            old.remove_pre_hook(self._pre_hook)

        if new is not None and self.recording:
            new.add_pre_hook(self._pre_hook)
            
        return
    
#### EOF ######################################################################
