""" The base class for all resource context adapters. """


# Enthought library imports.
from enthought.naming.api import ContextAdapter
from enthought.traits.api import Instance


class ResourceContextAdapter(ContextAdapter):
    """ The base class for all resource context adapters. """

    #### 'ResourceContextAdapter' interface ###################################
    
    # The resource type that we are the context adapter for.
    resource_type = Instance('enthought.envisage.resource.ResourceType')

    ###########################################################################
    # 'ResourceContextAdapter' interface.
    ###########################################################################

    def save(self):
        """ Saves the context. """

        self._save_context(self)
                
        return

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _save_context(self, context):
        """ Saves a context. """

        for binding in context.list_bindings(''):
            if context.is_context(binding.name):
                self._save_context(binding.obj)

            else:
                context.rebind(binding.name, binding.obj)
                
        return

#### EOF ######################################################################
