#-------------------------------------------------------------------------------
#  
#  Define a repository 'root' directory  
#  
#  Written by: David C. Morrill
#  
#  Date: 03/22/2006
#  
#  (c) Copyright 2006 by Enthought, Inc.
#  
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#  Imports:  
#-------------------------------------------------------------------------------

from enthought.traits.api \
    import HasPrivateTraits, Str, Int, Directory, false
from enthought.traits.ui.api import View, Item 
    
#-------------------------------------------------------------------------------
#  'RepositoryRoot' class:  
#-------------------------------------------------------------------------------

class RepositoryRoot ( HasPrivateTraits ):
    
    #---------------------------------------------------------------------------
    #  Trait definitions:  
    #---------------------------------------------------------------------------
    
    # The user oriented 'UI' name of the repository root:
    name = Str

    # The path to the top-level directory of the repository root:
    path = Directory 
    
    # Can the contents of the root be changed by the user?
    locked = false
    
    # Can the root itself be renamed or deleted by the user?
    permanent = false
    
    # Should this root be persisted as a user preference item:
    persistent = false
    
    # Sort order priority (for ordering collections of roots):
    priority = Int

    #---------------------------------------------------------------------------
    #  Traits view definitions:  
    #---------------------------------------------------------------------------
    
    view = View( 
        Item( 'name', 
              tooltip = 'Name to display in the repository browser'
        ), 
        Item( 'path', 
              tooltip = 'Root directory for this part of the repository',
              width   = 300
        )
    )
    
