""" Cookie, yum """

# Enthought libraries
from enthought.traits.api import HasTraits, Str

class Cookie( HasTraits ):
    """ A Cookie is a marker for a capability.
    The capability is defined as a CookieAction.
    The CookieManager maintains the coorespondence between cookies and
    resources (AbstractResource) and objects.
    A CookieAction is available to an object if the actions require_cookie is
    associated with the object or any resource that matches the object.
    """
    
    # unique id for this cookie class, every subclass should override.
    id = Str( 'enthought.envisage.project.cookie' ) 
    
    # description, subclasses should assign appropriate description
    description = Str
    
    # fixme: why not use __class__ and __doc__
    
#### EOF #####################################################################
    