""" The internal plugin definition. """


# Enthought library imports.
from enthought.envisage import PluginDefinition

# Plugin definition imports.
from enthought.envisage.workbench.workbench_plugin_definition import \
     Perspective, View, Workbench


# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module).
ID = "enthought.envisage.internal"


###############################################################################
# Extensions.
###############################################################################

workbench = Workbench(
    views = [
        View(
            id         = ID + ".view.application_view.ApplicationView",
            class_name = ID + ".view.application_view.ApplicationView",
            image      = "images/application_view.png",
            name       = "Application",
            position   = "left"
        ),
        
        View(
            id         = ID + ".view.resource_detail_view.ResourceDetailView",
            class_name = ID + ".view.resource_detail_view.ResourceDetailView",
            image      = "images/resource_detail_view.png",
            name       = "Resource Detail",
            position   = "right"
        ),

        View(
            id         = ID + ".view.wx_view.WXView",
            class_name = ID + ".view.wx_view.WXView",
            image      = "images/wx_view.png",
            name       = "WX Windows",
            position   = "bottom"
        ),
    ],

    perspectives = [
        Perspective(
            id = ID + ".SystemPerspective",
            name = "System",
            show_editor_area = False,
            
            contents = [
                Perspective.Item(
                    id = ID + ".view.application_view.ApplicationView",
                    position = "left"
                ),

                Perspective.Item(
                    id = ID + ".view.resource_detail_view.ResourceDetailView",
                    position  = "right"
                ),
            ]
        )
    ]
)

###############################################################################
# The plugin definition.
###############################################################################

class InternalPluginDefinition(PluginDefinition):
    # The plugin's globally unique identifier.
    id = ID

    # General information about the plugin.
    name          = "Internal Plugin"
    version       = "1.0.0"
    provider_name = "Enthought Inc"
    provider_url  = "www.enthought.com"
    
    # The Id's of the plugins that this plugin requires.
    requires = ["enthought.envisage.core"]

    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [workbench]

#### EOF ######################################################################
