""" The cookie required for a resource to be opened. """

# major package imports
import os
import wx

# Enthought library imports.
from enthought.envisage import get_application
from enthought.envisage.core.core_plugin import CorePlugin
from enthought.envisage.core.core_plugin_definition import UserAddedPlugin
from enthought.envisage.project.action.open_cookie import OpenCookie
from enthought.util.wx.dialog import confirmation

class OpenPluginCookie(OpenCookie):
    """ The cookie required for a resource to be opened. """

    ##########################################################################
    # 'OpenCookie' interface.
    ##########################################################################

    def open(self, window, binding, **kw):
        """ Opens the resource referenced by the binding. """

        result = confirmation(window.control,
                              'Add ' + binding.obj.path + ' as a plugin?',
                              'Add Plugin')

        if result == wx.ID_YES or result == wx.ID_OK:
            app = get_application()

            # we have to construct the path to the plugin_definition file
            # with the zip
            zipname, ext = os.path.splitext(os.path.basename(binding.obj.path))
            path = binding.obj.absolute_path + '/' + zipname + \
                   '_plugin_definition.py'
            core = \
               app.service_registry.get_service(CorePlugin.IADDITIONS_MANAGER)
            uap = UserAddedPlugin(path = path, enabled = True)
            core.user_added_plugins.append(uap)
            core._load_and_start_additional_plugins()

        return

#### EOF ######################################################################
