""" Base class for all function actions. """


# Enthought library imports.
from enthought.pyface.action.api import Action
from enthought.traits.api import Str


class FunctionAction(Action):
    """ Base class for all function-based actions. """

    #### 'FunctionAction' interface ##########################################

    # The symbol name of the function.
    #
    # This value is in the form 'foo.bar.baz.my_function'. And is turned into 
    # an import statement of the form 'from foo.bar.baz import my_function'.
    function_name = Str

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self, event):
        """ Performs the action. """

        function = event.application.import_symbol(self.function_name)
        function()

        # fixme: Experimental macro recording stuff.
        mod = '.'.join(self.function_name.split('.')[:-1])
        func = self.function_name.split('.')[-1]

        s1 = 'from %s import %s\n' % (mod, func)
        s2 = '%s()\n' % func

        return

#### EOF ######################################################################
