""" Envisage package Copyright 2003, 2004, 2005 Enthought, Inc. """

# FIXME: Importing from the package scope is deprecated.  Remove the below
# once other code has been updated to import from the api module.


from core.application import Application
from core.application_object import ApplicationObject
from core.extension_item import ExtensionItem
from core.extension_point import ExtensionPoint
from core.plugin_definition import PluginDefinition
from core.plugin import Plugin
from core.runnable import Runnable
from traits import UOL, InstanceUOL


# The global singleton application instance (initialized via
# '''_set_application()''' from within the ''''Application()''' constructor).
#
# The goal here is to allow the user to import the singleton application
# instance using ``from enthought.envisage import application``.  However, we
# still want to keep the definition of the '''Application''' class separate, and
# since we don't control when the application is instantiated, I can't think of
# a better way at the moment! Smells tho' don't it?!?
#
# It smells because other modules will not see changes to '''application''';
# they get a copy of application (the object reference if not None) as it is at
# the time that they import '''application'''.  Thus, this only works if
# '''application''' is never reassigned and as long as it has already been
# assigned.
#
# Thus, '''application''' is intended to be used by user scripts that are run
# in the context of an application.  Module writers should use
# '''get_application()'''.
#
# Actually, we should eliminate use of the singleton everywhere *apart* from
# user scripts. Hence, if you see a current use of '''get_application()''' then
# we need to figure out how to remove it!
application = None

def _set_application(value):
    """ Sets the shared application instance.

    This function is called ''only'' from within the '''Application()'''
    constructor and is ''not'' for public use (hence the '_'!).

    """

    global application
    application = value

    return

def get_application():
    """ Returns the singleton application. """
    return application


# fixme: Errr, this probably shouldn't actually be defined in here!
def join(*args):
    """ Like 'os.path.join', but it allows only a module as the first argument.

    This is useful when creating lists of plug-in definition file names when
    defining an application.

    """

    import os.path
    import types

    if len(args) > 0 and type(args[0]) is types.ModuleType:
        args    = list(args)
        args[0] = os.path.abspath(os.path.dirname(args[0].__file__))
        args    = tuple(args)

    return os.path.join(*args)


# FIXME: This singleton is used to modify the imports or behavior of other code
# while we are in the middle of switching from the UI plug-in to the workbench
# plug-in. This is necessary to keep things working with the old UI while we
# port and test things with the new workbench plug-in.  Once that happens,
# we should delete this global and anything using it!
#
# To use the workbench plug-in (vs. the UI plug-in) call the setter
# method and pass a value of '''True'''
using_workbench = False


def _set_using_workbench(value):
    """ Sets the shared '''using_workbench''' instance.

        This function should only be called once per application and that
        should be before anything using the UI or Workbench plug-in!
    """

    global using_workbench
    using_workbench = value
    return


def get_using_workbench():
    """ Returns the current value of the '''using_workbench''' flag.
    """
    return using_workbench


def get_active_window():
    """ Returns the active window.

    This checks the '''using_workbench''' flag and gets the active window from
    either the UI plug-in or the Workbench plug-in, as appropriate.

    """

    if get_using_workbench():
        from enthought.envisage.workbench.services import IWORKBENCH
        window = get_application().get_service(IWORKBENCH).active_window.control

    else:
        from enthought.envisage.ui import UIPlugin
        window = UIPlugin.instance.active_window

    return window

#### EOF ######################################################################
