#!/usr/bin/perl
# @(#) pretest_selector.pl	05-05-2004	Ulrich Jansen
#
# Bereitstellen eines Parameter-Strings fr die Pre-Tests.
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

BEGIN {
	if ($^O !~ /win32/i) {
		unshift @INC, ("/devtool/TOOL/tool/lib/perl5", "/devtool/TOOL/tool/lib/Perl", "/devtool/TOOL/tool/bin", "/SAP_DB/TESTDB");
	}
	unshift @INC, ($^O =~ /win32/i ? "\\SAP_DB\\TESTDB\\lib" : "/SAP_DB/TESTDB/lib");
}

use strict;

use Net::HTTP;
use HTTP::Status;
use Sys::Hostname;
use File::Basename;
use XML::Simple;
use Getopt::Long;
use QAConnect;

$| = 1;
print "\npretest_selector 1.00a (c)2004, SAP AG\n\n";

my $use_packid = 0;

GetOptions('use_packid' => \$use_packid);

my $log_file = dirname((caller())[1]);
$log_file .= "/pretest_selector.log";
$log_file  =~ tr/\//\\/ if ($^O=~/.*win32.*/i);

# Local Variables:
my $DEBUG = 1;
my $hostname 		= lc(hostname());
my $row_count       	= -1;
my $act_relver      	= "";
my $lockpath		= ($^O =~ /win32/i ? "\\SAP_DB\\TESTDB\\Locks\\" : "/SAP_DB/TESTDB/Locks/");

QAConnect::setdbg($DEBUG);

# Get Servers data from QADB.
my ($rc, $href)     = QAConnect::httpsql_request("QADB_HTTPSQL", "select IDPLATFORM, RELEASE_FILTER from TESTER.SERVERS where HOST like '$hostname\%'", 1); 
(ref($href) and $href->{'Rows'}->{'Row'}[0]->{'IDPLATFORM'}) or QAConnect::throw_error("UNKNOWN HOSTNAME", "This host ($hostname) has no entry in the SERVERS table!", 1);

# Copy href data to local variables:
my $platform_id     = $href->{'Rows'}->{'Row'}[0]->{'IDPLATFORM'};
my $relver_filter   = ($href->{'Rows'}->{'Row'}[0]->{'RELEASE_FILTER'} ne "?" ? $href->{'Rows'}->{'Row'}[0]->{'RELEASE_FILTER'} : "");
my $time_ago        = QAConnect::getisotime (time - (24*60*60));

($rc, $href)        = QAConnect::httpsql_request("QADB_HTTPSQL", "SELECT ID, RELVER, QASTATUS, TS, IDOBJSTATUS, PRIORITY, BUILDPFX FROM TESTER.PRIOMAKES WHERE TS>$time_ago AND IDPLATFORM=$platform_id AND IDOBJSTATUS>=1000 AND RELEVANCE='1' AND QASTATUS='DEV' ORDER BY IDOBJSTATUS ASC, PRIORITY DESC, ID DESC", 1);
(ref($href) and ($href->{'Rows'}->{'Row'}[0]->{'ID'} ne "")) or QAConnect::throw_error("OOPS!", "There have been no Makes/Tests for me!", 111);
my $max_row = scalar(@{$href->{'Rows'}->{'Row'}});

mkdir ($lockpath, 0777);

while (1) 
{ 
	$row_count   ++;
	$act_relver  = $href->{'Rows'}->{"Row"}[$row_count]->{'RELVER'} . $href->{'Rows'}->{"Row"}[$row_count]->{'QASTATUS'};
	last if ($row_count >= $max_row);
	QAConnect::dbgout("Checking $act_relver ($href->{'Rows'}->{'Row'}[$row_count]->{'ID'}) - row $row_count");
	if (($relver_filter ne "") && ($relver_filter ne "?") && ($act_relver !~ /$relver_filter/i))
	{
		QAConnect::dbgout("Release $act_relver does not match filter '$relver_filter'.");
		next;
	}

	if (-e "$lockpath$href->{'Rows'}->{'Row'}[$row_count]->{'ID'}.lock") {
		QAConnect::dbgout("Make ID has already been marked before! Skipping...");
		next;
	}

	next if (check_doubles($row_count));

	if (check_fulltested($href->{'Rows'}->{'Row'}[$row_count]->{'ID'}))
	{
		QAConnect::dbgout("Release '$act_relver' ($href->{'Rows'}->{'Row'}[$row_count]->{'ID'}) has already been completely tested --> skipping.");
		next;
	}

	next if (check_pretested($href->{'Rows'}->{'Row'}[$row_count]->{'ID'}));

	QAConnect::dbgout("Marking make id $href->{'Rows'}->{'Row'}[$row_count]->{'ID'}.");
	if (open ( LOCK_FILE, ">$lockpath$href->{'Rows'}->{'Row'}[$row_count]->{'ID'}.lock"))
	{
		print LOCK_FILE scalar(localtime) . "\n";
		close (LOCK_FILE);
	}
	else
	{
		QAConnect::throw_error("ERROR", "Could not open file '$lockpath$href->{'Rows'}->{'Row'}[$row_count]->{'ID'}.lock'!");
	}

	$act_relver = uc($act_relver);
	# Print statistics:
	QAConnect::dbgout("MAKE_ID     = $href->{'Rows'}->{'Row'}[$row_count]->{'ID'}");
	QAConnect::dbgout("LC_RELEASE  = $act_relver");
	QAConnect::dbgout("TIMESTAMP   = $href->{'Rows'}->{'Row'}[$row_count]->{'TS'}");
	QAConnect::dbgout("OBJ_STATUS  = $href->{'Rows'}->{'Row'}[$row_count]->{'IDOBJSTATUS'}");
	QAConnect::dbgout("PRIORITY    = $href->{'Rows'}->{'Row'}[$row_count]->{'PRIORITY'}");
	# Dump output 
	open(ENV_OUT, ">>$ENV{'DTM_TASKEXPORTFILE'}") or QAConnect::throw_error("ENV OPEN ERROR", "Can't open temporary env output file!", 1);
	print ENV_OUT "\nLC_RELEASE=$act_relver\n";
	if ($use_packid) {
		print ENV_OUT "TEST_PKGS= -packid $href->{'Rows'}->{'Row'}[$row_count]->{'ID'}\n";
	} else {
		print ENV_OUT "TEST_PKGS= -package $act_relver\n";
	}
	print ENV_OUT "MAKE_ID=$href->{'Rows'}->{'Row'}[$row_count]->{'ID'}\n";
	close (ENV_OUT) or QAConnect::throw_error("OOPS!", "Can't close temoprary env file?!");
	QAConnect::dbgout("Successfully created env file: $ENV{'DTM_TASKEXPORTFILE'}");
	QAConnect::dbgout("[" . scalar(localtime) . "]: Selected '$act_relver' (ID:$href->{'Rows'}->{'Row'}[$row_count]->{'ID'}) for pre_test.");
	exit(0);	
}
QAConnect::throw_error("OOPS!", "There seem to be nothing to test for me! ($row_count lines scanned)\n", 111);

##############################################################################
# check_doubles() - checks for later entries.
##############################################################################
sub check_doubles
{
	my $row = shift;
	my $trow = 0;
	QAConnect::dbgout("Checking for doubles (from row $trow to $max_row)");
	while ($trow < $max_row)
	{
		unless ($trow == $row)
		{
			if (($href->{'Rows'}->{'Row'}[$row]->{'RELVER'} eq $href->{'Rows'}->{'Row'}[$trow]->{'RELVER'}) and ($href->{'Rows'}->{'Row'}[$row]->{'QASTATUS'} eq $href->{'Rows'}->{'Row'}[$trow]->{'QASTATUS'}) and ($href->{'Rows'}->{'Row'}[$row]->{'BUILDPFX'} eq $href->{'Rows'}->{'Row'}[$trow]->{'BUILDPFX'}) and ($href->{'Rows'}->{'Row'}[$row]->{'TS'} lt $href->{'Rows'}->{'Row'}[$trow]->{'TS'}))
			{
				QAConnect::dbgout("\t" . $href->{'Rows'}->{'Row'}[$row]->{'RELVER'} . $href->{'Rows'}->{'Row'}[$row]->{'BUILDPFX'}. $href->{'Rows'}->{'Row'}[$row]->{'QASTATUS'} . " <-> " . $href->{'Rows'}->{'Row'}[$trow]->{'RELVER'} . $href->{'Rows'}->{'Row'}[$trow]->{'BUILDPFX'} . $href->{'Rows'}->{'Row'}[$trow]->{'QASTATUS'} . ", $href->{'Rows'}->{'Row'}[$row]->{'TS'} < $href->{'Rows'}->{'Row'}[$trow]->{'TS'} ? YES");
				return 1;
			}
			else
			{ QAConnect::dbgout("\t" . $href->{'Rows'}->{'Row'}[$row]->{'RELVER'} . $href->{'Rows'}->{'Row'}[$row]->{'BUILDPFX'}. $href->{'Rows'}->{'Row'}[$row]->{'QASTATUS'} . " <-> " . $href->{'Rows'}->{'Row'}[$trow]->{'RELVER'} . $href->{'Rows'}->{'Row'}[$trow]->{'BUILDPFX'} . $href->{'Rows'}->{'Row'}[$trow]->{'QASTATUS'} . ", $href->{'Rows'}->{'Row'}[$row]->{'TS'} < $href->{'Rows'}->{'Row'}[$trow]->{'TS'} ? NO"); }
		}
		$trow ++;
	}
	return 0;
}

##############################################################################
# check_pretested() - Check, if Version was already tested.
##############################################################################
sub check_pretested
{
	my $makeid = shift;

	my ($ok, $res) = QAConnect::httpsql_request("QADB_HTTPSQL", "SELECT DRIVERSTARTED FROM TESTER.JAVATESTINFO WHERE MAKEKEY=$makeid AND TESTSEQUENCE like 'pretest_lc.seq'");

	QAConnect::dbgout("Checking MakeID ($makeid) for pre-test entries.");

	if ($ok && $res->{'Rows'}->{'Row'}[0]->{'DRIVERSTARTED'} ne "")
	{
		QAConnect::dbgout("\tMakeID '$makeid' has already been pre-tested at $res->{'Rows'}->{'Row'}[0]->{'DRIVERSTARTED'}.");
		return 1;
	}

	return 0;
}

##############################################################################
# check_fulltested() - Check, if Version was already tested.
##############################################################################
sub check_fulltested
{
	my $id = shift;
	my $testcount = 0;
	my $sharp = 0;
	QAConnect::dbgout("Checking Testruns for ID $id:");
	my ($ok, $res) = QAConnect::httpsql_request("QADB_HTTPSQL", "select IDOBJSTATUS from makes where id=$id", 1);
	return 0 unless($ok);

	my $stat = $res->{'Rows'}->{'Row'}[0]->{'IDOBJSTATUS'};
	if ($stat == 1000)
	{
		QAConnect::dbgout("ID $id has marked as 'ready to be tested', so let's test it!");
		return 0;
	}
	($ok, $res) = QAConnect::httpsql_request("QADB_HTTPSQL", "select OBJSTATUS from monitor_sessions where idmake=$id order by id desc", 1);
	return $testcount unless ($ok && defined ($res->{'Rows'}->{'Row'}));
	my $maxrow = scalar(@{$res->{'Rows'}->{'Row'}});
	return 0 unless ($maxrow);
	QAConnect::dbgout("\tFound $maxrow sessions.");
	$testcount ++;
	my $actrow = 1;
	while ($actrow < $maxrow) { $testcount ++ if ($res->{'Rows'}->{"Row"}[$actrow]->{'OBJSTATUS'} =~ /^end\sof\stesting/i); $actrow++; }
	QAConnect::dbgout("\tFound $testcount running/completed tests.");
	return $testcount;
}

