#!/devtool/local/bin/perl
#
# Execute a single command in a certain chr-Environment
#

BEGIN {
    if ($^O !~ /MSWin32/i) {
		unshift @INC, "/devtool/local/bin";
		unshift @INC, "/devtool/TOOL/tool/bin";
		unshift @INC, "/devtool/TOOL/tool/lib/perl5";
		unshift @INC, "/devtool/TOOL/tool/lib";
		unshift @INC, "/SAP_DB/TESTDB/lib";
		unshift @INC, "/SAP_DB/TESTDB";
    }
}
$| = 1;

use testdbchr;
use IniFile;
use Getopt::Long;

my %options = ();
if (! &GetOptions(  \%options,
            'h|help|?',
            'dir=s',
	    'cmd=s',
	    'cfg=s'	    
            )) {
    print("Run testdb.pl -h for help");
    exit(1);
}

my $tdb;
my $cfg = "";

#
# Get the .cfg-File right
#

if ($options{'cfg'}) {
	if (!(-r $options{'cfg'})) {
		print "Could not read $cfg\nExiting\n";
		exit(1);
	}
	$cfg = $options{'cfg'};
}

if ($options{'dir'}) {
    $options{'dir'} = "0$options{'dir'}" unless ($options{'dir'} =~ /^0\d$/);
	if (!($options{'cmd'})) {
		print "Specify a cmd-Parameter, please\nSee $0 --help for additional information\n";
		exit(0);
	}

	print "Reading configuration in /SAP_DB/chr/etc/$options{'dir'}..";
	
	my $etc_ref = IniFile::load("/SAP_DB/chr/etc/$options{'dir'}");
	unless($etc_ref) {
		print "..FAILED\n";
		exit(1);
	}
		
	print "OK\nChecking configuration parameters..";
	unless ($etc_ref->{'IDMAKE'} && $etc_ref->{'IDSESSION'}) {
		print "..FAILED\n\tIDMAKE = $etc_ref->{'IDMAKE'}\n\tIDSESSION = $etc_ref->{'IDSESSION'}\n";
		exit(1);
	}
	
	print "..OK\nCreating new testdbchr-Instance..\n";
	$tdb = testdbchr->new({	'ID' => $etc_ref->{'IDMAKE'},
				'profile' => $options{'test_profile'},
				'DIR' => $options{'dir'},
				'profile' => $options{'test_profile'},
				'no_objstat' => ($options{'no_objstat'} ? 1 : 0),
				'CFG' => $cfg },
				{'ID' => $etc_ref->{'IDSESSION'}});
	
	$tdb->verify_chr();
	$tdb->su_jump_in_chr();
	$tdb->doCmd($options{'cmd'});
} else {
	print "$0 - Execute a Programm in a chr-Area. Syntax:\n$0 -dir <CHR_DIRECTORY> -cmd <COMMAND>\n";
}

exit(0);



