#!/devtool/local/bin/perl
#
# Run all the MaxDB/liveCache Benchmarks, depening
# on the time we got started
#



my $currtime	= time();
my $dow		= (localtime ($currtime))[6];	# Day of Week
my $hod		= (localtime ($currtime))[2];	# Hour of Day

my @testnames;
my @testrel;
my @testq;


if ((($hod == 12) || ($hod == 13)) && ($dow = 1)) { # Montag mittags
	push (@testrel,   ('7403DEV', '7500DEV', '7501DEV', '7600DEV'));
	push (@testnames, ('wisconsinReferenceRun'));

} elsif ($hod >= 18) {
	push (@testnames, (' -c lvcBench_reference_74.cfg lvcBench_reference.seq', ' -c tp2_reference_74.cfg tp2_reference.seq'));
	
	if ($dow == 1) {                               ## Montag
		push (@testrel,   ('7500DEV'));
	} elsif ($dow == 2) {                          ## Dienstag
		push (@testrel,   ('7500COR'));
	} elsif ($dow == 3) {                          ## Mittwoch
		push (@testrel,   ('7403DEV'));
	} elsif ($dow == 4) {                          ## Donnerstag
		push (@testrel,   ('7403COR'));
	} elsif ($dow == 5) {                          ## Freytag
		pop  (@testnames);
		push (@testnames, ' -c tp2_76.cfg tp2_sqldbc_reference.seq');
		push (@testrel,   ('7600DEV'));
	} else {
		print ">>DEBUG: It's WEEKEND! I don't wanna do high performance tests when it's weekend!\n";
		exit 1;
	}
} else {
	print ">>DEBUG: This is NOT my time! (Probably yours don't either...;-))\n";
	exit 1;
}

$dircnt = 1;

foreach $version (@testrel) {
	
	if ($^O =~ /MSWin32/i) {
		system ("perl inst.pl $version");
		foreach $test (@testnames) {
			system ("perl testdb.pl -package $version -testname  \"" . $test . "\"");
		}
	} else {
		$dir = sprintf ("%02d", $dircnt);
		print "We are at dir: $dir\n";
		print "ulimit -n 20000 ; cd /SAP_DB/TESTDB && /devtool/local/bin/perl chr_destroy.pl -dir $dir\n";
		system ("ulimit -n 20000 ; cd /SAP_DB/TESTDB && /devtool/local/bin/perl chr_destroy.pl -dir $dir");
		print "ulimit -n 20000 ; cd /SAP_DB/TESTDB && /devtool/local/bin/perl chr_install.pl -package $version -no_objstat\n";
		system ("ulimit -n 20000 ; cd /SAP_DB/TESTDB && /devtool/local/bin/perl chr_install.pl -package $version -no_objstat");
		foreach $test (@testnames) {
			print   "ulimit -n 20000 ; cd /SAP_DB/TESTDB && /devtool/local/bin/perl chr_single_test.pl -dir $dir -test \"" . $test . "\"";
			system ("ulimit -n 20000 ; cd /SAP_DB/TESTDB && /devtool/local/bin/perl chr_single_test.pl -dir $dir -test \"" . $test . "\"");
		}
		$dircnt++;
	}
}

if ($dow == 1) {
	system("ulimit -n 20000 ; cd /SAP_DB/TESTDB && /devtool/local/bin/perl chr_single_test.pl -dir 04 -test \" -c lvcBench_reference_74.cfg lvcBench_reference.seq\"");
	system("ulimit -n 20000 ; cd /SAP_DB/TESTDB && /devtool/local/bin/perl chr_single_test.pl -dir 03 -test \"  -c tp2_reference_74.cfg tp2_reference.seq\"");
}

exit(0);