/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>

#ifdef HAVE_SDL_MIXER
# include <SDL/SDL_mixer.h>
#endif

#include <math.h>
#include "world_geometry.h"
#include "timers.h"
#include "hut.h"
#include "bonus.h"
#include "mango.h"
//#include "map.h"


double VECTEUR2D::getNorme()
{
  return sqrt(x * x + z * z);
}

double VECTEUR2D::scalaire(VECTEUR2D v)
{
  return (x * v.x + z * v.z);
}

double VECTEUR2D::determinant(VECTEUR2D v)
{
  return x * v.z - z * v.x;
}

VECTEUR2D VECTEUR2D::somme(VECTEUR2D v)
{
  VECTEUR2D toto;

  toto.x = x + v.x;
  toto.z = z + v.z;

  return toto;
}

void VECTEUR2D::divisePar(double div)
{
  if (div)
  {
    x = x / div;
    z = z / div;
  }

  else
    fprintf(stderr, "Erreur : division par 0.\n");
}

VECTEUR2D VECTEUR2D::_divisePar(double div)
{
  VECTEUR2D toto;

  if (div)
  {
    toto.x = x / div;
    toto.z = z / div;
  }

  else
    fprintf(stderr, "Erreur : division par 0.\n");

  return toto;
}
