/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>

#ifdef HAVE_SDL_MIXER
# include <SDL/SDL_mixer.h>
#endif

#include <math.h>
#include <string.h>

#include "font.h"

#include "timers.h"
#include "world_geometry.h"
#include "hut.h"
#include "bonus.h"
#include "mango.h"
#include "world_building.h"
#include "texture.h"
#include "sector.h"
#include "map.h"
#include "system_gl.h"
#include "draw_scene_gl.h"
#include "hud.h"

extern player_t *player;
extern game_data_t *world;
extern char *filename;
extern hud_t *hud;

void load_mm_textures()
{
  const char *i_posJoueur = SHXMAN_DATA "hud/pos_joueur.png";
  const char *i_posShmollux = SHXMAN_DATA "hud/pos_shmollux.png";
  const char *i_posBoite = SHXMAN_DATA "hud/pos_boite.png";
  const char *i_posBonus = SHXMAN_DATA "hud/pos_bonus.png";
  const char *i_posGomme = SHXMAN_DATA "hud/pos_shmixgomme.png";
  const char *i_fakeMinimap = SHXMAN_DATA "hud/fake_minimap.png";
  const char *i_mask_minimap = SHXMAN_DATA "hud/mask_minimap.png";

  
  LoadTexture(i_mask_minimap, &hud->t_mask_minimap);
  LoadTexture(i_fakeMinimap, &hud->t_fakeMinimap);

  LoadTexture(i_posJoueur, &hud->t_posJoueur);
  LoadTexture(i_posShmollux, &hud->t_posShmollux);
  LoadTexture(i_posBoite, &hud->t_posBoite);
  LoadTexture(i_posBonus, &hud->t_posBonus);
  LoadTexture(i_posGomme, &hud->t_posGomme);
  hud->MINIMAP_W = 140;
  hud->MINIMAP_H = 140;
}

void load_map_minimap_only()
{
  char *i_minimap;
  int tFichier = strlen(filename);
  i_minimap = new char[tFichier+1];
  strcpy(i_minimap, filename);
  i_minimap[tFichier-1] = 'p';

  LoadTexture(i_minimap, &hud->t_minimap);
  printf(" Loading minimap: %s\n",i_minimap);

  delete [] i_minimap;
}

void unload_map_minimap_only()
{
  glDeleteTextures(1,&hud->t_minimap);
  hud->t_minimap=0;
}

void draw_full_minimap()
{
  draw_mm_background();
  
  if (player->sees_minimap)
    {
      draw_mm_player();
      draw_mm_bonus();
      draw_mm_shmollux();
    }
}

void draw_mm_background()
{
  if (player->sees_minimap) glBindTexture(GL_TEXTURE_2D, hud->t_minimap);
  else  glBindTexture(GL_TEXTURE_2D, hud->t_fakeMinimap);
  //glDisable(GL_BLEND);
  glBegin(GL_QUADS);

  glTexCoord2f(0, 0);
  glVertex2f(0, 0);
  glTexCoord2f((GLfloat) PIC_MINIMAP_W / PIC_MINIMAP_W, 0);
  glVertex2f(hud->MINIMAP_W, 0);
  glTexCoord2f((GLfloat) PIC_MINIMAP_W / PIC_MINIMAP_W,
               (GLfloat) PIC_MINIMAP_H / PIC_MINIMAP_H);
  glVertex2f(hud->MINIMAP_W, hud->MINIMAP_H);
  glTexCoord2f(0, (GLfloat) PIC_MINIMAP_H / PIC_MINIMAP_H);
  glVertex2f(0, hud->MINIMAP_H);

  glEnd();
  //glEnable(GL_BLEND);

}

void draw_mm_player()
{

  float debutX, debutY, finX, finY;
  float POS_J_W = (float) (hud->MINIMAP_H / world->size);
  float POS_J_H = (float) (hud->MINIMAP_W / world->size);

  debutX = (float) (player->map_x * POS_J_W);
  debutY = (float) (hud->MINIMAP_H - (POS_J_H * (player->map_z + 1)));
  finX = (float) (debutX + POS_J_W);
  finY = (float) (debutY + POS_J_H);

  //glDisable(GL_BLEND);
  glBindTexture(GL_TEXTURE_2D, hud->t_posJoueur);

  glBegin(GL_QUADS);

  glTexCoord2f(0, 0);
  glVertex2f(debutX, debutY);

  glTexCoord2f(1, 0);
  glVertex2f(finX, debutY);

  glTexCoord2f(1,1);
  glVertex2f(finX, finY);

  glTexCoord2f(0, 1);
  glVertex2f(debutX, finY);

  glEnd();

  //glEnable(GL_BLEND);
}

void draw_mm_bonus()
{
  float debutX, debutY, finX, finY;
  float POS_J_W = hud->MINIMAP_H / world->size;
  float POS_J_H = hud->MINIMAP_W / world->size;
  float coordX = 0, coordY = 0;

  for (int i = 0; i < world->size_square; i++)
  {
    if ((world->map[i].bonus > -1)
        || (world->map[i].is_ditugomme))
    {

      coordX = i % (world->size);
      coordY = (int) floor(i / (world->size));

      debutX = coordX * POS_J_W;
      debutY = hud->MINIMAP_H - (POS_J_H * (coordY + 1));
      finX = debutX + POS_J_W;
      finY = debutY + POS_J_H;

      if (world->map[i].is_ditugomme)
        glBindTexture(GL_TEXTURE_2D, hud->t_posBoite);

      else if (world->map[i].bonus == E_SHMIXGOMME)
        glBindTexture(GL_TEXTURE_2D, hud->t_posGomme);

      else
        glBindTexture(GL_TEXTURE_2D, hud->t_posBonus);

      glBegin(GL_QUADS);

      glTexCoord2f(0, 0);
      glVertex2f(debutX, debutY);

      glTexCoord2f((GLfloat) 1, 0);
      glVertex2f(finX, debutY);

      glTexCoord2f( 1,1);
      glVertex2f(finX, finY);

      glTexCoord2f(0, 1);
      glVertex2f(debutX, finY);

      glEnd();
    }

  }
}

void draw_mm_shmollux()
{
  int i=0, j=0;
  hut_t *hut;
  shmollux_t *shmollux;

  for (i=0; i < world->num_huts; i++)
    {
      hut = &world->huts[i];
      for (j=0; j < hut->total_num_shmol; j++)
	{
	  shmollux = &hut->shmollux[j];
	  
	  if ( (shmollux->status == ETAT_POURSUIVANT)
	       || (shmollux->status == ETAT_POURSUIVI)
	       || (shmollux->status == ETAT_STOP))

	    {
	      float debutX, debutY, finX, finY;
	      float POS_J_W = (float) (hud->MINIMAP_H / world->size);
	      float POS_J_H = (float) (hud->MINIMAP_W / world->size);

	      debutX = (float) (shmollux->map_x * POS_J_W);
	      debutY = (float) (hud->MINIMAP_H - (POS_J_H * (shmollux->map_z + 1)));
	      finX = (float) (debutX + POS_J_W);
	      finY = (float) (debutY + POS_J_H);

	      glBindTexture(GL_TEXTURE_2D, hud->t_posShmollux);

	      glBegin(GL_QUADS);

	      glTexCoord2f(0, 0);
	      glVertex2f(debutX, debutY);

	      glTexCoord2f(1, 0);
	      glVertex2f(finX, debutY);

	      glTexCoord2f(1,1);
	      glVertex2f(finX, finY);

	      glTexCoord2f(0, 1);
	      glVertex2f(debutX, finY);

	      glEnd();
	    }
	}
    }

}
