/* Generated by GOB (v2.0.11) on Sun Mar  6 22:34:27 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include "mn-pop3-mailbox.h"

#include "mn-pop3-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 33 "mn-pop3-mailbox.gob"

#include "config.h"
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <glib/gi18n.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <eel/eel.h>
#include "mn-mailbox-private.h"
#include "mn-authenticated-mailbox-private.h"
#include "mn-client-session.h"
#include "mn-util.h"
#include "mn-md5.h"
#include "mn-message-mime.h"

  enum
  {
    STATE_GREETING = MN_CLIENT_SESSION_INITIAL_STATE,
    STATE_CAPA,
#ifdef WITH_SSL
    STATE_STLS,
#endif
#ifdef WITH_SASL
    STATE_AUTH,
#endif
    STATE_APOP,
    STATE_USER,
    STATE_PASS,
    STATE_LIST,
    STATE_RETR,
    STATE_QUIT
  };

  enum
  {
    RESULT_ERROR_QUIT		= -1, /* server reported an error, quit normally */
    RESULT_ERROR_END		= -2  /* server reported an error, close the connection */
  };

  struct _MNClientSessionPrivate
  {
    MNMailbox			*mailbox;
    MNAuthenticatedMailbox	*authenticated_mailbox;
    MNPOP3Mailbox		*self;
    MNClientSession		*session;
    gboolean			in_list;
    gboolean			in_retr;
    char			*apop_timestamp;
    GSList			*auth_mechanisms;
#ifdef WITH_SSL
    gboolean			stls_supported;
    gboolean			stls_completed;
#endif
#ifdef WITH_SASL
    const char			*sasl_mechanism;
#endif
    gboolean			authenticated;
    gboolean			login_delay_user;
    GSList			*message_numbers;
    GSList			*current_message_number;
    GSList			*messages;
    GString			*current_message;
  };

  typedef enum
  {
    RESPONSE_OK,
    RESPONSE_ERR,
    RESPONSE_LIST_ITEM,
    RESPONSE_LIST_END,
    RESPONSE_CONTINUATION
  } ResponseType;

  struct _MNClientSessionResponse
  {
    ResponseType	type;
    char		*arguments;
  };

#line 107 "mn-pop3-mailbox.c"
/* self casting macros */
#define SELF(x) MN_POP3_MAILBOX(x)
#define SELF_CONST(x) MN_POP3_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_POP3_MAILBOX(x)
#define TYPE_SELF MN_TYPE_POP3_MAILBOX
#define SELF_CLASS(x) MN_POP3_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_POP3_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNPOP3Mailbox Self;
typedef MNPOP3MailboxClass SelfClass;

/* here are local prototypes */
static void mn_pop3_mailbox_init (MNPOP3Mailbox * o) G_GNUC_UNUSED;
static void mn_pop3_mailbox_class_init (MNPOP3MailboxClass * class) G_GNUC_UNUSED;
static GObject * ___2_mn_pop3_mailbox_constructor (GType type, unsigned int n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static gboolean ___3_mn_pop3_mailbox_impl_is (MNMailbox * dummy, MNURI * uri) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_capa_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_capa_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_stls_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_stls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static const char * mn_pop3_mailbox_sasl_get_username_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static const char * mn_pop3_mailbox_sasl_get_password_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_auth_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_auth_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_apop_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_apop_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_user_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_user_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_pass_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_pass_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_list_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_list_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_retr_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_retr_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_quit_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_quit_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void ___19_mn_pop3_mailbox_impl_check (MNMailbox * mailbox) G_GNUC_UNUSED;
static void mn_pop3_mailbox_notice_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_pop3_mailbox_warning_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static MNClientSessionResponse * mn_pop3_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_pop3_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_custom_handler_cb (MNClientSession * session, MNClientSessionResponse * response, int result, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_session_authenticate (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv, gboolean tried_apop, gboolean tried_pass) G_GNUC_UNUSED;
static int mn_pop3_mailbox_session_authenticated (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_pop3_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, MNClientSessionResponse * response) G_GNUC_UNUSED;
static void mn_pop3_mailbox_handle_list_response (MNClientSessionPrivate * priv, MNClientSessionResponse * response, gboolean retr) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNAuthenticatedMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_handle_greeting_cb mn_pop3_mailbox_handle_greeting_cb
#define self_enter_capa_cb mn_pop3_mailbox_enter_capa_cb
#define self_handle_capa_cb mn_pop3_mailbox_handle_capa_cb
#define self_enter_stls_cb mn_pop3_mailbox_enter_stls_cb
#define self_handle_stls_cb mn_pop3_mailbox_handle_stls_cb
#define self_sasl_get_username_cb mn_pop3_mailbox_sasl_get_username_cb
#define self_sasl_get_password_cb mn_pop3_mailbox_sasl_get_password_cb
#define self_enter_auth_cb mn_pop3_mailbox_enter_auth_cb
#define self_handle_auth_cb mn_pop3_mailbox_handle_auth_cb
#define self_enter_apop_cb mn_pop3_mailbox_enter_apop_cb
#define self_handle_apop_cb mn_pop3_mailbox_handle_apop_cb
#define self_enter_user_cb mn_pop3_mailbox_enter_user_cb
#define self_handle_user_cb mn_pop3_mailbox_handle_user_cb
#define self_enter_pass_cb mn_pop3_mailbox_enter_pass_cb
#define self_handle_pass_cb mn_pop3_mailbox_handle_pass_cb
#define self_enter_list_cb mn_pop3_mailbox_enter_list_cb
#define self_handle_list_cb mn_pop3_mailbox_handle_list_cb
#define self_enter_retr_cb mn_pop3_mailbox_enter_retr_cb
#define self_handle_retr_cb mn_pop3_mailbox_handle_retr_cb
#define self_enter_quit_cb mn_pop3_mailbox_enter_quit_cb
#define self_handle_quit_cb mn_pop3_mailbox_handle_quit_cb
#define self_notice_cb mn_pop3_mailbox_notice_cb
#define self_warning_cb mn_pop3_mailbox_warning_cb
#define self_response_new_cb mn_pop3_mailbox_response_new_cb
#define self_response_free_cb mn_pop3_mailbox_response_free_cb
#define self_custom_handler_cb mn_pop3_mailbox_custom_handler_cb
#define self_session_authenticate mn_pop3_mailbox_session_authenticate
#define self_session_authenticate_fallback mn_pop3_mailbox_session_authenticate_fallback
#define self_session_authenticated mn_pop3_mailbox_session_authenticated
#define self_session_set_error_from_arguments mn_pop3_mailbox_session_set_error_from_arguments
#define self_handle_list_response mn_pop3_mailbox_handle_list_response
GType
mn_pop3_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNPOP3MailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_pop3_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNPOP3Mailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_pop3_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_AUTHENTICATED_MAILBOX, "MNPOP3Mailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNPOP3Mailbox *)g_object_new(mn_pop3_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNPOP3Mailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNPOP3Mailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNPOP3Mailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNPOP3Mailbox *)g_object_new_valist (mn_pop3_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::finalize"
	MNPOP3Mailbox *self G_GNUC_UNUSED = MN_POP3_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 118 "mn-pop3-mailbox.gob"
	if(self->_priv->authentication_timer) { g_timer_destroy ((gpointer) self->_priv->authentication_timer); self->_priv->authentication_timer = NULL; }
#line 247 "mn-pop3-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_pop3_mailbox_init (MNPOP3Mailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,MNPOP3MailboxPrivate);
}
#undef __GOB_FUNCTION__
#line 120 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_class_init (MNPOP3MailboxClass * class G_GNUC_UNUSED)
#line 261 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;

	g_type_class_add_private(class,sizeof(MNPOP3MailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_AUTHENTICATED_MAILBOX);

#line 125 "mn-pop3-mailbox.gob"
	g_object_class->constructor = ___2_mn_pop3_mailbox_constructor;
#line 142 "mn-pop3-mailbox.gob"
	mn_mailbox_class->impl_is = ___3_mn_pop3_mailbox_impl_is;
#line 602 "mn-pop3-mailbox.gob"
	mn_mailbox_class->impl_check = ___19_mn_pop3_mailbox_impl_check;
#line 277 "mn-pop3-mailbox.c"
	g_object_class->finalize = ___finalize;
 {
#line 121 "mn-pop3-mailbox.gob"

    MN_MAILBOX_CLASS(class)->format = "POP3";
  
#line 284 "mn-pop3-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 125 "mn-pop3-mailbox.gob"
static GObject * 
___2_mn_pop3_mailbox_constructor (GType type G_GNUC_UNUSED, unsigned int n_construct_properties, GObjectConstructParam * construct_params)
#line 294 "mn-pop3-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::constructor"
{
#line 127 "mn-pop3-mailbox.gob"
	
    GObject *object;
    MNMailbox *mailbox;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    mailbox = MN_MAILBOX(object);

#ifndef WITH_SSL
    if (MN_URI_IS_SSL(mailbox->uri) || MN_URI_IS_INBAND_SSL(mailbox->uri))
      mn_mailbox_set_init_error(mailbox, _("SSL/TLS support has not been compiled in"));
#endif /* WITH_SSL */
  
    return object;
  }}
#line 317 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 142 "mn-pop3-mailbox.gob"
static gboolean 
___3_mn_pop3_mailbox_impl_is (MNMailbox * dummy G_GNUC_UNUSED, MNURI * uri)
#line 324 "mn-pop3-mailbox.c"
#define PARENT_HANDLER(___dummy,___uri) \
	((MN_MAILBOX_CLASS(parent_class)->impl_is)? \
		(* MN_MAILBOX_CLASS(parent_class)->impl_is)(___dummy,___uri): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::impl_is"
#line 142 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 142 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (MN_IS_URI (uri), (gboolean )0);
#line 335 "mn-pop3-mailbox.c"
{
#line 144 "mn-pop3-mailbox.gob"
	
    return MN_URI_IS_POP(uri);
  }}
#line 341 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 148 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 348 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_greeting_cb"
#line 148 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 148 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 148 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 357 "mn-pop3-mailbox.c"
{
#line 152 "mn-pop3-mailbox.gob"
	
    priv->session = session;
    
    switch (response->type)
      {
      case RESPONSE_OK:
	if (response->arguments)
	  {
	    char *timestamp;
	    
	    timestamp = strchr(response->arguments, '<');
	    if (timestamp)
	      {
		char *timestamp_end;
		
		timestamp_end = strchr(timestamp, '>');
		if (timestamp_end)
		  priv->apop_timestamp = g_strndup(timestamp, timestamp_end - timestamp + 1);
	      }
	  }
	return STATE_CAPA;
	
      case RESPONSE_ERR:	return RESULT_ERROR_END;
      default:			return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 386 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 179 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_capa_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 392 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_capa_cb"
#line 179 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 179 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 399 "mn-pop3-mailbox.c"
{
#line 182 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "CAPA");
  }}
#line 405 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 186 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_capa_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 411 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_capa_cb"
#line 186 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 186 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 186 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 420 "mn-pop3-mailbox.c"
{
#line 190 "mn-pop3-mailbox.gob"
	
    self_handle_list_response(priv, response, FALSE);

    switch (response->type)
      {
      case RESPONSE_OK:
	eel_g_slist_free_deep(priv->auth_mechanisms);
	priv->auth_mechanisms = NULL;
	priv->self->_priv->login_delay = 0;
	priv->login_delay_user = FALSE;
#ifdef WITH_SSL
	priv->stls_supported = FALSE;
#endif

	return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      case RESPONSE_ERR:
      case RESPONSE_LIST_END:
	if (priv->authenticated)
	  return STATE_LIST;

#ifdef WITH_SSL
	if (MN_URI_IS_INBAND_SSL(priv->mailbox->uri)
	    && ! MN_URI_IS_SSL(priv->mailbox->uri)
	    && ! priv->stls_completed)
	  {
	    if (priv->stls_supported)
	      return STATE_STLS;
	    else
	      {
		mn_client_session_error(priv->session, _("server does not support in-band SSL/TLS"));
		return STATE_QUIT;
	      }
	  }
	else
#endif /* WITH_SSL */
	  return self_session_authenticate(priv);
      
      case RESPONSE_LIST_ITEM:
	{
	  char **tokens;
	  gboolean login_delay_error = FALSE;
	  
	  tokens = g_strsplit(response->arguments, " ", 0);
	  if (tokens[0])
	    {
	      if (! strcmp(tokens[0], "SASL"))
		{
		  int i;
		  
		  for (i = 1; tokens[i]; i++)
		    priv->auth_mechanisms = g_slist_append(priv->auth_mechanisms, g_strdup(tokens[i]));
		}
#ifdef WITH_SSL
	      else if (! strcmp(tokens[0], "STLS"))
		priv->stls_supported = TRUE;
#endif /* WITH_SSL */
	      else if (! strcmp(tokens[0], "LOGIN-DELAY"))
		{
		  if (tokens[1] && mn_str_isnumeric(tokens[1])
		      && (! tokens[2]
			  || (! tokens[3]
			      && ! priv->authenticated
			      && ! strcmp(tokens[2], "USER"))))
		    {
		      priv->self->_priv->login_delay = atoi(tokens[1]);
		      if (tokens[2])
			priv->login_delay_user = TRUE;
		    }
		  else
		    login_delay_error = TRUE;
		}
	    }
	  g_strfreev(tokens);
	  
	  if (login_delay_error)
	    return mn_client_session_error(session, _("invalid arguments for the LOGIN-DELAY capability"));
	}
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 507 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 275 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_stls_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 513 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_stls_cb"
#line 275 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 275 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 520 "mn-pop3-mailbox.c"
{
#line 278 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SSL
    return mn_client_session_write(session, "STLS");
#else
    g_return_val_if_reached(0);
#endif /* WITH_SSL */
  }}
#line 530 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 286 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_stls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 536 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_stls_cb"
#line 286 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 286 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 286 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 545 "mn-pop3-mailbox.c"
{
#line 290 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SSL
    switch (response->type)
      {
      case RESPONSE_OK:
	priv->stls_completed = TRUE;
	return mn_client_session_enable_ssl(session)
	  ? STATE_CAPA
	  : RESULT_ERROR_END;

      case RESPONSE_ERR:
	return self_session_authenticate(priv);

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
#else
    g_return_val_if_reached(0);
#endif /* WITH_SSL */
  }}
#line 568 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 311 "mn-pop3-mailbox.gob"
static const char * 
mn_pop3_mailbox_sasl_get_username_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 574 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::sasl_get_username_cb"
#line 311 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (const char * )0);
#line 311 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (const char * )0);
#line 581 "mn-pop3-mailbox.c"
{
#line 314 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SASL
    return priv->mailbox->uri->username;
#else
    g_return_val_if_reached(NULL);
#endif /* WITH_SASL */
  }}
#line 591 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 322 "mn-pop3-mailbox.gob"
static const char * 
mn_pop3_mailbox_sasl_get_password_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 597 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::sasl_get_password_cb"
#line 322 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (const char * )0);
#line 322 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (const char * )0);
#line 604 "mn-pop3-mailbox.c"
{
#line 325 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SASL
    mn_authenticated_mailbox_fill_password(priv->authenticated_mailbox);
    return priv->authenticated_mailbox->password;
#else
    g_return_val_if_reached(NULL);
#endif /* WITH_SASL */
  }}
#line 615 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 334 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_auth_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 621 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_auth_cb"
#line 334 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 334 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 628 "mn-pop3-mailbox.c"
{
#line 337 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SASL
    if (mn_client_session_sasl_authentication_start(priv->session,
						    "pop",
						    priv->auth_mechanisms,
						    priv->mailbox->uri->authmech,
						    &priv->sasl_mechanism,
						    TRUE /* [1] */))
      return mn_client_session_write(session, "AUTH %s", priv->sasl_mechanism);
    else
      return priv->authenticated_mailbox->cancelled
	? STATE_QUIT
	: self_session_authenticate_fallback(priv, FALSE, FALSE);

    /*
     * [1] http://www.ietf.org/internet-drafts/draft-siemborski-rfc1734bis-03.txt
     * section 4 specifies that POP3 supports the initial client
     * response feature of SASL.
     */
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 654 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 361 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_auth_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 660 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_auth_cb"
#line 361 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 361 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 361 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 669 "mn-pop3-mailbox.c"
{
#line 365 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SASL
    switch (response->type)
      {
      case RESPONSE_OK:
	return mn_client_session_sasl_authentication_done(session)
	  ? self_session_authenticated(priv)
	  : MN_CLIENT_SESSION_RESULT_END;
	
      case RESPONSE_ERR:
	return priv->authenticated_mailbox->cancelled
	  ? STATE_QUIT
	  : self_session_authenticate_fallback(priv, FALSE, FALSE);
	
      case RESPONSE_CONTINUATION:
	return mn_client_session_sasl_authentication_step(session, response->arguments);
	
      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 696 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 390 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_apop_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 702 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_apop_cb"
#line 390 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 390 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 709 "mn-pop3-mailbox.c"
{
#line 393 "mn-pop3-mailbox.gob"
	
    MNMD5Context context;
    char buf[33];
  
    g_return_val_if_fail(priv->apop_timestamp != NULL, 0);

    mn_authenticated_mailbox_fill_password(priv->authenticated_mailbox);
    if (! priv->authenticated_mailbox->password)
      return STATE_QUIT;

    mn_md5_init(&context);
    mn_md5_update(&context, priv->apop_timestamp, strlen(priv->apop_timestamp));
    mn_md5_update(&context, priv->authenticated_mailbox->password, strlen(priv->authenticated_mailbox->password));
    mn_md5_end(&context, buf);

    return mn_client_session_write(session, "APOP %s %s", priv->mailbox->uri->username, buf);
  }}
#line 729 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 411 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_apop_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 735 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_apop_cb"
#line 411 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 411 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 411 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 744 "mn-pop3-mailbox.c"
{
#line 415 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	return self_session_authenticated(priv);
	
      case RESPONSE_ERR:
	return self_session_authenticate_fallback(priv, TRUE, FALSE);

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 760 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 429 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_user_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 766 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_user_cb"
#line 429 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 429 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 773 "mn-pop3-mailbox.c"
{
#line 432 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "USER %s", priv->mailbox->uri->username);
  }}
#line 779 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 436 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_user_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 785 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_user_cb"
#line 436 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 436 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 436 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 794 "mn-pop3-mailbox.c"
{
#line 440 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	return STATE_PASS;

      case RESPONSE_ERR:
	return RESULT_ERROR_QUIT;

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 810 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 454 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_pass_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 816 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_pass_cb"
#line 454 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 454 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 823 "mn-pop3-mailbox.c"
{
#line 457 "mn-pop3-mailbox.gob"
	
    mn_authenticated_mailbox_fill_password(priv->authenticated_mailbox);
    if (! priv->authenticated_mailbox->password)
      return STATE_QUIT;

    return mn_client_session_write(session, "PASS %s", priv->authenticated_mailbox->password);
  }}
#line 833 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 465 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_pass_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 839 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_pass_cb"
#line 465 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 465 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 465 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 848 "mn-pop3-mailbox.c"
{
#line 469 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	return self_session_authenticated(priv);

      case RESPONSE_ERR:
	return self_session_authenticate_fallback(priv, TRUE, TRUE);

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 864 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 483 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_list_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 870 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_list_cb"
#line 483 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 483 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 877 "mn-pop3-mailbox.c"
{
#line 486 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "LIST");
  }}
#line 883 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 490 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_list_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 889 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_list_cb"
#line 490 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 490 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 490 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 898 "mn-pop3-mailbox.c"
{
#line 494 "mn-pop3-mailbox.gob"
	
    self_handle_list_response(priv, response, FALSE);

    switch (response->type)
      {
      case RESPONSE_OK:
	return MN_CLIENT_SESSION_RESULT_CONTINUE;

      case RESPONSE_LIST_END:
	priv->current_message_number = priv->message_numbers;
	return STATE_RETR;

      case RESPONSE_ERR:
	return RESULT_ERROR_END;

      case RESPONSE_LIST_ITEM:
	{
	  int num;
	  int size;
	  
	  if (sscanf(response->arguments, "%d %d", &num, &size) == 2)
	    priv->message_numbers = g_slist_append(priv->message_numbers, GINT_TO_POINTER(num));
	  else			/* compliance error */
	    return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	}
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 932 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 526 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_retr_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 938 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_retr_cb"
#line 526 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 526 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 945 "mn-pop3-mailbox.c"
{
#line 529 "mn-pop3-mailbox.gob"
	
    if (priv->current_message_number)
      return mn_client_session_write(session, "RETR %i", GPOINTER_TO_INT(priv->current_message_number->data));
    else
      {
	GDK_THREADS_ENTER();
	mn_mailbox_set_messages(priv->mailbox, priv->messages);
	gdk_flush();
	GDK_THREADS_LEAVE();
	
	return STATE_QUIT;
      }
  }}
#line 961 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 543 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_retr_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 967 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_retr_cb"
#line 543 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 543 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 543 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 976 "mn-pop3-mailbox.c"
{
#line 547 "mn-pop3-mailbox.gob"
	
    self_handle_list_response(priv, response, TRUE);

    switch (response->type)
      {
      case RESPONSE_OK:
	if (priv->current_message)
	  g_string_free(priv->current_message, TRUE);
	priv->current_message = g_string_new(NULL);
	return MN_CLIENT_SESSION_RESULT_CONTINUE;

      case RESPONSE_LIST_END:
	priv->messages = g_slist_append(priv->messages,
					mn_message_new_from_buffer(priv->mailbox->uri,
								   priv->current_message->str,
								   priv->current_message->len));
	priv->current_message_number = priv->current_message_number->next;
	return STATE_RETR;

      case RESPONSE_ERR:
	priv->messages = g_slist_append(priv->messages,
					mn_message_new_from_error(priv->mailbox->uri,
								  response->arguments ? response->arguments : _("unknown error")));
	priv->current_message_number = priv->current_message_number->next;
	return STATE_RETR;

      case RESPONSE_LIST_ITEM:
	g_string_append_printf(priv->current_message, "%s\n", response->arguments);
	return MN_CLIENT_SESSION_RESULT_CONTINUE;

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 1013 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 582 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_quit_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1019 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_quit_cb"
#line 582 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 582 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1026 "mn-pop3-mailbox.c"
{
#line 585 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "QUIT");
  }}
#line 1032 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 589 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_quit_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1038 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_quit_cb"
#line 589 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 589 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 589 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1047 "mn-pop3-mailbox.c"
{
#line 593 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:		return MN_CLIENT_SESSION_RESULT_END;
      case RESPONSE_ERR:	return RESULT_ERROR_END;
      default:			return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 1058 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 602 "mn-pop3-mailbox.gob"
static void 
___19_mn_pop3_mailbox_impl_check (MNMailbox * mailbox G_GNUC_UNUSED)
#line 1064 "mn-pop3-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->impl_check) \
		(* MN_MAILBOX_CLASS(parent_class)->impl_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::impl_check"
#line 602 "mn-pop3-mailbox.gob"
	g_return_if_fail (mailbox != NULL);
#line 602 "mn-pop3-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1074 "mn-pop3-mailbox.c"
{
#line 604 "mn-pop3-mailbox.gob"
	
    Self *self = SELF(mailbox);
    MNClientSessionState states[] = {
      { STATE_GREETING,		NULL,			self_handle_greeting_cb },
      { STATE_CAPA,		self_enter_capa_cb,	self_handle_capa_cb },
#ifdef WITH_SSL
      { STATE_STLS,		self_enter_stls_cb,	self_handle_stls_cb },
#endif
#ifdef WITH_SASL
      { STATE_AUTH,		self_enter_auth_cb,	self_handle_auth_cb },
#endif
      { STATE_APOP,		self_enter_apop_cb,	self_handle_apop_cb },
      { STATE_USER,		self_enter_user_cb,	self_handle_user_cb },
      { STATE_PASS,		self_enter_pass_cb,	self_handle_pass_cb },
      { STATE_LIST,		self_enter_list_cb,	self_handle_list_cb },
      { STATE_RETR,		self_enter_retr_cb,	self_handle_retr_cb },
      { STATE_QUIT,		self_enter_quit_cb,	self_handle_quit_cb },
      
      MN_CLIENT_SESSION_STATES_END
    };
    MNClientSessionCallbacks callbacks = {
      self_notice_cb,
      self_warning_cb,
      self_response_new_cb,
      self_response_free_cb,
      self_custom_handler_cb,
      NULL,			/* pre_read */
      NULL,			/* post_read */
#ifdef WITH_SASL
      self_sasl_get_username_cb,
      self_sasl_get_password_cb,
#endif
    };
    MNClientSessionPrivate priv;
    gboolean status;
    GError *err = NULL;

    PARENT_HANDLER(mailbox);

    if (selfp->login_delay && selfp->authentication_timer)
      {
	double elapsed;

	g_timer_stop(selfp->authentication_timer);
	elapsed = g_timer_elapsed(selfp->authentication_timer, NULL);

	if (elapsed < selfp->login_delay)
	  {
	    int sleeptime;
	    
	    sleeptime = selfp->login_delay - elapsed;
	    mn_mailbox_notice(mailbox,
			      ngettext("honouring LOGIN-DELAY, sleeping for %i second",
				       "honouring LOGIN-DELAY, sleeping for %i seconds",
				       sleeptime),
			      sleeptime);
	    sleep(sleeptime);
	  }
      }
  
    memset(&priv, 0, sizeof(priv));
    priv.mailbox = mailbox;
    priv.authenticated_mailbox = MN_AUTHENTICATED_MAILBOX(mailbox);
    priv.self = self;

    status = mn_client_session_run(states,
				   &callbacks,
#ifdef WITH_SSL
				   MN_URI_IS_SSL(mailbox->uri),
#endif
				   mailbox->uri->hostname,
				   mailbox->uri->port,
				   &priv,
				   &err);

    GDK_THREADS_ENTER();

    if (! status)
      {
	mn_mailbox_set_error(mailbox, "%s", err->message);
	g_error_free(err);
      }
    mn_mailbox_end_check(mailbox);

    gdk_flush();
    GDK_THREADS_LEAVE();

    g_free(priv.apop_timestamp);
    eel_g_slist_free_deep(priv.auth_mechanisms);
    g_slist_free(priv.message_numbers);
    mn_g_object_slist_free(priv.messages);
    if (priv.current_message)
      g_string_free(priv.current_message, TRUE);
  }}
#line 1171 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 699 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_notice_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv)
#line 1178 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::notice_cb"
#line 699 "mn-pop3-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 699 "mn-pop3-mailbox.gob"
	g_return_if_fail (str != NULL);
#line 699 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1187 "mn-pop3-mailbox.c"
{
#line 703 "mn-pop3-mailbox.gob"
	
    mn_mailbox_notice(priv->mailbox, "%s", str);
  }}
#line 1193 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 707 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_warning_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv)
#line 1199 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::warning_cb"
#line 707 "mn-pop3-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 707 "mn-pop3-mailbox.gob"
	g_return_if_fail (str != NULL);
#line 707 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1208 "mn-pop3-mailbox.c"
{
#line 711 "mn-pop3-mailbox.gob"
	
    mn_mailbox_warning(priv->mailbox, "%s", str);
  }}
#line 1214 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 715 "mn-pop3-mailbox.gob"
static MNClientSessionResponse * 
mn_pop3_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv)
#line 1220 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::response_new_cb"
#line 715 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (MNClientSessionResponse * )0);
#line 715 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (input != NULL, (MNClientSessionResponse * )0);
#line 715 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (MNClientSessionResponse * )0);
#line 1229 "mn-pop3-mailbox.c"
{
#line 719 "mn-pop3-mailbox.gob"
	
    MNClientSessionResponse *response = NULL;

    /*
     * About character set handling:
     *
     * RFC 1939 3 specifies that "keywords and arguments consist of
     * printable ASCII characters", however that refers to
     * commands. Nothing is said about responses.
     *
     * We need responses to be valid UTF-8, because they might end up
     * showing up in the UI (for instance, through
     * session_set_error_from_arguments()).
     *
     * However, RETR multiline responses do not need to (and must not)
     * be validated: most servers send them in whatever charset the
     * original message is, and our mn-message-mime implementation
     * handles that.
     */
    if (priv->in_retr || g_utf8_validate(input, -1, NULL))
      {
	if (priv->in_list)
	  {
	    response = g_new0(MNClientSessionResponse, 1);
	    if (! strcmp(input, "."))
	      response->type = RESPONSE_LIST_END;
	    else if (g_str_has_prefix(input, ".."))
	      {
		response->type = RESPONSE_LIST_ITEM;
		response->arguments = g_strdup(input + 1); /* skip the initial dot */
	      }
	    else
	      {
		response->type = RESPONSE_LIST_ITEM;
		response->arguments = g_strdup(input);
	      }
	  }
	else
	  {
	    if (g_str_has_prefix(input, "+ "))
	      {
		response = g_new0(MNClientSessionResponse, 1);
		response->type = RESPONSE_CONTINUATION;
		response->arguments = g_strdup(input + 2);
	      }
	    else
	      {
		ResponseType type;
		int after_status = 0;
		
		if (g_str_has_prefix(input, "+OK"))
		  {
		    type = RESPONSE_OK;
		    after_status = 3;
		  }
		else if (g_str_has_prefix(input, "-ERR"))
		  {
		    type = RESPONSE_ERR;
		    after_status = 4;
		  }
		
		if (after_status)
		  {
		    if (input[after_status] == 0 || input[after_status] == ' ')
		      {
			response = g_new0(MNClientSessionResponse, 1);
			response->type = type;
			if (input[after_status] == ' ')
			  response->arguments = g_strdup(input + after_status + 1);
		      }
		  }
	      }
	  }
      }
    
    return response;
  }}
#line 1309 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 797 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1315 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::response_free_cb"
#line 797 "mn-pop3-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 797 "mn-pop3-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 797 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1324 "mn-pop3-mailbox.c"
{
#line 801 "mn-pop3-mailbox.gob"
	
    g_free(response->arguments);
    g_free(response);
  }}
#line 1331 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 806 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_custom_handler_cb (MNClientSession * session, MNClientSessionResponse * response, int result, MNClientSessionPrivate * priv)
#line 1337 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::custom_handler_cb"
#line 806 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 806 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 806 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1346 "mn-pop3-mailbox.c"
{
#line 811 "mn-pop3-mailbox.gob"
	
    switch (result)
      {
      case RESULT_ERROR_QUIT:
	self_session_set_error_from_arguments(priv, response);
	return STATE_QUIT;

      case RESULT_ERROR_END:
	self_session_set_error_from_arguments(priv, response);
	return MN_CLIENT_SESSION_RESULT_END;
	
    default:
      g_return_val_if_reached(0);
      }
  }}
#line 1364 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 827 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_session_authenticate (MNClientSessionPrivate * priv)
#line 1370 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_authenticate"
#line 827 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1375 "mn-pop3-mailbox.c"
{
#line 829 "mn-pop3-mailbox.gob"
	
    if (priv->mailbox->uri->authmech)
      {
	if (*priv->mailbox->uri->authmech != '+')
	  {
#ifdef WITH_SASL
	    return STATE_AUTH;
#else
	    mn_client_session_error(priv->session, _("a SASL authentication mechanism was selected but SASL support has not been compiled in"));
	    return STATE_QUIT;
#endif /* WITH_SASL */
	  }
	else
	  {
	    if (! strcmp(priv->mailbox->uri->authmech, "+APOP"))
	      {
		if (priv->apop_timestamp)
		  return STATE_APOP;
		else
		  {
		    mn_client_session_error(priv->session, _("server does not support APOP authentication"));
		    return STATE_QUIT;
		  }
	      }
	    else if (! strcmp(priv->mailbox->uri->authmech, "+USERPASS"))
	      return STATE_USER;
	    else
	      {
		mn_client_session_error(priv->session, _("unknown authentication mechanism \"%s\""), priv->mailbox->uri->authmech);
		return STATE_QUIT;
	      }
	  }
      }
    else
      {
#ifdef WITH_SASL
	if (priv->auth_mechanisms)
	  return STATE_AUTH;
#endif /* WITH_SASL */
	if (priv->apop_timestamp)
	  return STATE_APOP;
	else
	  return STATE_USER;
      }
  }}
#line 1423 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 875 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv, gboolean tried_apop, gboolean tried_pass)
#line 1429 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_authenticate_fallback"
#line 875 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1434 "mn-pop3-mailbox.c"
{
#line 879 "mn-pop3-mailbox.gob"
	
    if (! priv->mailbox->uri->authmech)
      {
	if (! tried_apop && priv->apop_timestamp)
	  {
	    mn_client_session_notice(priv->session, _("falling back to APOP authentication"));
	    return STATE_APOP;
	  }
	else if (! tried_pass)
	  {
	    mn_client_session_notice(priv->session, _("falling back to USER/PASS authentication"));
	    return STATE_USER;
	  }
      }

    if (! priv->mailbox->uri->password && priv->authenticated_mailbox->prompted)
      {
	mn_authenticated_mailbox_authentication_failed(priv->authenticated_mailbox);
	return self_session_authenticate(priv);
      }
    else
      {
	mn_client_session_error(priv->session, _("authentication failed"));
	return STATE_QUIT;
      }
  }}
#line 1463 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 906 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_session_authenticated (MNClientSessionPrivate * priv)
#line 1469 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_authenticated"
#line 906 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1474 "mn-pop3-mailbox.c"
{
#line 908 "mn-pop3-mailbox.gob"
	
    priv->authenticated = TRUE;
    if (priv->self->_priv->login_delay)
      {
	if (priv->self->_priv->authentication_timer)
	  g_timer_start(priv->self->_priv->authentication_timer);
	else
	  priv->self->_priv->authentication_timer = g_timer_new();
      }
    return priv->login_delay_user ? STATE_CAPA : STATE_LIST;
  }}
#line 1488 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 920 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, MNClientSessionResponse * response)
#line 1494 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_set_error_from_arguments"
#line 920 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 920 "mn-pop3-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 1501 "mn-pop3-mailbox.c"
{
#line 923 "mn-pop3-mailbox.gob"
	
    if (response->arguments)
      mn_client_session_error(priv->session, "\"%s\"", response->arguments);
    else
      mn_client_session_error(priv->session, _("unknown server error"));
  }}
#line 1510 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 930 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_handle_list_response (MNClientSessionPrivate * priv, MNClientSessionResponse * response, gboolean retr)
#line 1516 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_list_response"
#line 930 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 930 "mn-pop3-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 1523 "mn-pop3-mailbox.c"
{
#line 934 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	priv->in_list = TRUE;
	priv->in_retr = retr;
	break;

      case RESPONSE_LIST_ITEM:	/* nop */
	break;

      default:
	priv->in_list = FALSE;
	priv->in_retr = FALSE;
	break;
      }
  }}
#line 1543 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
