/***************************************************************************
 *
 * This file is covered by a dual licence. You can choose whether you
 * want to use it according to the terms of the GNU GPL version 2, or
 * under the terms of Zorp Professional Firewall System EULA located
 * on the Zorp installation CD.
 *
 * $Id: zobject.h,v 1.6 2003/10/17 17:38:28 bazsi Exp $
 *
 ***************************************************************************/

#ifndef ZORP_ZOBJECT_H_INCLUDED
#define ZORP_ZOBJECT_H_INCLUDED

/* this might need to be moved to libzorpll */

#include <zorp/zorplib.h>

#ifdef __cplusplus
extern "C" {
#endif


typedef struct _ZClass ZClass;
typedef struct _ZObject ZObject;

typedef struct _ZObjectFuncs
{
  gint method_count;
  void (*free_fn)(ZObject *self);
} ZObjectFuncs;

struct _ZObject
{
  gint ref_cnt;
  GStaticMutex ref_lock;
  ZClass *isa;
};

extern ZClass ZObject__class;


struct _ZClass
{
  ZObject super;
  gboolean funcs_resolved; /* indicates whether function inheritance was already performed */
  struct _ZClass *super_class;
  gchar *name;
  gsize size;
  ZObjectFuncs *funcs; 
};

extern ZClass ZClass__class;

typedef ZClass ZInterface;

#define Z_CLASS_HEADER    { 1, G_STATIC_MUTEX_INIT, &ZClass__class }, 0

#define Z_CLASS(class)       (&class##__class)

#define Z_CAST(inst, class) ((class *) z_object_check_compatible((ZObject *) inst, Z_CLASS(class)))

#define Z_FUNCS(inst, class) ((class##Funcs *) (z_object_check_compatible((ZObject *) inst, Z_CLASS(class))->isa->funcs))
#define Z_SUPER(inst, class) ((class##Funcs *) (z_object_check_compatible((ZObject *) inst, Z_CLASS(class))->isa->super_class->funcs))
#define Z_FUNCS_COUNT(class) ((sizeof(class##Funcs)-sizeof(gint))/sizeof(void (*)(void)))
#define Z_NEW(class)         (class *) z_object_new(Z_CLASS(class))
#define Z_NEW_COMPAT(class, compat) (compat *) z_object_new_compatible(class, Z_CLASS(compat))

ZObject *z_object_new(ZClass *class);
ZObject *z_object_new_compatible(ZClass *class, ZClass *compat);
ZObject *z_object_ref(ZObject *self);
void z_object_unref(ZObject *self);
gboolean z_object_is_compatible(ZObject *self, ZClass *class);
gboolean z_object_is_subclass(ZClass *class, ZClass *subclass);
gboolean z_object_is_instance(ZObject *self, ZClass *class);

#if ZORPLIB_ENABLE_DEBUG

static inline ZObject *
z_object_check_compatible(ZObject *self, ZClass *class)
{
  g_assert(!self || z_object_is_compatible(self, class));
  return self;
}

#else

static inline ZObject *
z_object_check_compatible(ZObject *self, ZClass *class G_GNUC_UNUSED)
{
  return self;
}

#endif

/* function declaration for virtual functions */

void z_object_free_method(ZObject *s);

/* virtual function wrapper */
static inline void
z_object_free(ZObject *self)
{
  Z_FUNCS(self, ZObject)->free_fn(self);
}

#ifdef __cplusplus
}
#endif

#endif
