/***************************************************************************
 *
 * This file is covered by a dual licence. You can choose whether you
 * want to use it according to the terms of the GNU GPL version 2, or
 * under the terms of Zorp Professional Firewall System EULA located
 * on the Zorp installation CD.
 *
 * $Id: error.c,v 1.2 2003/04/08 13:32:28 sasa Exp $
 *
 * Author  : void
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <glib.h>
#include <zorp/error.h>

#ifdef G_OS_WIN32
/* it's not complete... only contains error codes used somewhere */
static int
z_errno_translate(int e)
{
  switch (e)
    {
      case EAGAIN: /* a.k.a. EWOULDBLOCK */
      case EINPROGRESS:
        return WSAEWOULDBLOCK;
      case ENOTSOCK:
        return WSAENOTSOCK;
      case EINTR:
        /* WSAEINTR does exist, but has a different meaning */
        return 0;
      default:
        return e;
    }
}
#endif

gboolean
z_errno_is(int e)
{
#ifdef G_OS_WIN32
  int err;
  
  err = WSAGetLastError();
  if (err == z_errno_translate(e))
    return TRUE;
#endif
  return (errno == e);
}

int
z_errno_get(void)
{
#ifdef G_OS_WIN32
  return WSAGetLastError();
#else
  return errno;
#endif
}

void
z_errno_set(int e)
{
#ifdef G_OS_WIN32
  WSASetLastError(e);
#endif
  errno = e;
}
