.\" Copyright 1999 Sun Microsystems, Inc.  All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbKeysymToModifiers __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbKeysymToModifiers \- Finds the set of modifiers bound to a particular keysym 
on the core keyboard
.SH SYNOPSIS
.HP
.B unsigned int XkbKeysymToModifiers
.BI "(\^Display *" "dpy" "\^,"
.BI "KeySym " "ks" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to X server
.TP
.I \- ks
keysym of interest
.SH DESCRIPTION
.LP
.I XkbKeysymToModifiers 
finds the set of modifiers currently bound to the keysym 
.I ks 
on the core keyboard. The value returned is the mask of modifiers bound to the 
keysym 
.I ks. 
If no modifiers are bound to the keysym, 
.I XkbKeysymToModifiers 
returns zero; otherwise, it returns the inclusive OR of zero or more of the 
following: ShiftMask, ControlMask, LockMask, Mod1Mask, Mod2Mask, Mod3Mask, 
Mod4Mask, and Mod5Mask.
